/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.station.split;

import bibliothek.extension.gui.dock.station.split.SizeManager;
import bibliothek.gui.DockController;
import bibliothek.gui.DockFrontend;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.event.DockFrontendAdapter;
import bibliothek.gui.dock.event.DockFrontendListener;
import bibliothek.gui.dock.event.DockRelocatorAdapter;
import bibliothek.gui.dock.event.DockRelocatorListener;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.xml.XElement;
import java.awt.Insets;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class DockFrontendSizeManager
implements SizeManager {
    private Map<Dockable, Double> sizes = new HashMap<Dockable, Double>();
    private DockFrontend frontend;
    private DockRelocatorListener relocatorListener = new DockRelocatorAdapter(){

        public void init(DockController controller, Dockable dockable) {
            double dockableSize;
            if (DockFrontendSizeManager.this.needToTrackChange(dockable) && (dockableSize = DockFrontendSizeManager.this.computeRelativeSizeOfDockable(dockable)) >= 0.0) {
                DockFrontendSizeManager.this.put(dockable, dockableSize);
            }
        }
    };
    private DockFrontendListener frontendListener = new DockFrontendAdapter(){

        public void removed(DockFrontend frontend, Dockable dockable) {
            DockFrontendSizeManager.this.sizes.remove(dockable);
        }
    };
    private AdjacentDockFactory<Double> sizeConverter = new AdjacentDockFactory<Double>(){

        @Override
        public boolean interested(DockElement element) {
            return DockFrontendSizeManager.this.sizes.containsKey(element);
        }

        @Override
        public boolean interested(PerspectiveElement element) {
            return false;
        }

        @Override
        public String getID() {
            return "dock.extension.DockFrontendSizeManager.sizes";
        }

        @Override
        public Double getLayout(DockElement element, Map<Dockable, Integer> children) {
            return (Double)DockFrontendSizeManager.this.sizes.get(element);
        }

        @Override
        public Double getPerspectiveLayout(PerspectiveElement element, Map<PerspectiveDockable, Integer> children) {
            return null;
        }

        @Override
        public Double read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
            return in.readDouble();
        }

        @Override
        public Double read(XElement element, PlaceholderStrategy placeholders) {
            return element.getDouble();
        }

        @Override
        public void setLayout(DockElement element, Double layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
            this.setLayout(element, layout, placeholders);
        }

        @Override
        public void setLayout(DockElement element, Double layout, PlaceholderStrategy placeholders) {
            Dockable dockable = element.asDockable();
            if (dockable != null) {
                DockFrontendSizeManager.this.sizes.put(dockable, layout);
            }
        }

        @Override
        public void write(Double layout, DataOutputStream out) throws IOException {
            out.writeDouble(layout);
        }

        @Override
        public void write(Double layout, XElement element) {
            element.setDouble(layout);
        }
    };

    public double getSize(Dockable dockable) {
        Double size = this.sizes.get(dockable);
        if (size == null) {
            return -1.0;
        }
        return size;
    }

    public void setFrontend(DockFrontend frontend) {
        if (this.frontend != frontend) {
            if (this.frontend != null) {
                this.frontend.getController().getRelocator().removeDockRelocatorListener(this.relocatorListener);
                this.frontend.removeFrontendListener(this.frontendListener);
                this.frontend.unregisterAdjacentFactory(this.sizeConverter);
                this.sizes.clear();
            }
            this.frontend = frontend;
            if (this.frontend != null) {
                this.frontend.getController().getRelocator().addDockRelocatorListener(this.relocatorListener);
                this.frontend.addFrontendListener(this.frontendListener);
                this.frontend.registerAdjacentFactory(this.sizeConverter);
            }
        }
    }

    protected boolean needToTrackChange(Dockable dockable) {
        Root root;
        SplitNode child;
        SplitDockStation parentStation = this.getFirstAncestorSplitDockStation(dockable);
        boolean needToTrack = false;
        if (parentStation != null && (child = (root = parentStation.getRoot()).getChild()) instanceof Node) {
            needToTrack = true;
        }
        return needToTrack;
    }

    private double computeRelativeSizeOfDockable(Dockable dockable) {
        double size = -1.0;
        SplitDockStation station = this.getFirstAncestorSplitDockStation(dockable);
        if (station != null) {
            SplitNode splitNode = station.getRoot().getChild();
            double stationSize = 0.0;
            double dockableSize = 0.0;
            SplitDockStation.Orientation orientation = SplitDockStation.Orientation.HORIZONTAL;
            if (splitNode instanceof Node) {
                orientation = ((Node)splitNode).getOrientation();
            }
            Insets insets = station.getBasePane().getInsets();
            if (orientation == SplitDockStation.Orientation.HORIZONTAL) {
                stationSize = station.getWidth() - insets.left - insets.right;
                dockableSize = dockable.getComponent().getWidth();
            } else {
                stationSize = station.getHeight() - insets.top - insets.bottom;
                dockableSize = dockable.getComponent().getHeight();
            }
            size = dockableSize / stationSize;
        }
        if (Double.isNaN(size)) {
            size = -1.0;
        }
        return size;
    }

    private SplitDockStation getFirstAncestorSplitDockStation(Dockable dockable) {
        DockStation parent;
        Dockable currentDockable = dockable;
        while ((parent = currentDockable.getDockParent()) != null) {
            if (parent instanceof SplitDockStation) {
                return (SplitDockStation)parent;
            }
            currentDockable = parent.asDockable();
            if (currentDockable != null) continue;
            return null;
        }
        return null;
    }

    private void put(Dockable dockable, double size) {
        this.sizes.put(dockable, size);
    }
}

