/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.swing;

import bibliothek.gui.dock.util.font.FontModifier;
import java.awt.Font;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class FontUpdater {
    private FontModifier modifier;
    private Font original;
    private boolean onFontUpdate = false;
    private JComponent component;

    public FontUpdater(JComponent jComponent) {
        this.component = jComponent;
        jComponent.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!FontUpdater.this.onFontUpdate) {
                    FontUpdater.this.original = (Font)propertyChangeEvent.getNewValue();
                    FontUpdater.this.updateFont();
                }
            }
        });
        jComponent.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                FontUpdater.this.updateFont();
            }
        });
        this.original = jComponent.getFont();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterUpdateUI() {
        try {
            this.onFontUpdate = false;
            this.component.setFont(this.original);
        }
        finally {
            this.onFontUpdate = false;
        }
    }

    public void leaveUpdateUI() {
        this.updateFont();
    }

    public void setFontModifier(FontModifier fontModifier) {
        if (this.modifier != fontModifier) {
            this.modifier = fontModifier;
            this.updateFont();
        }
    }

    public FontModifier getFontModifier() {
        return this.modifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFont() {
        try {
            this.onFontUpdate = true;
            this.component.setFont(this.original);
            Font font = this.component.getFont();
            Font font2 = font == null || this.modifier == null ? this.original : this.modifier.modify(font);
            this.component.setFont(font2);
        }
        finally {
            this.onFontUpdate = false;
        }
    }
}

