/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.menu.CombinedMenuContent;
import bibliothek.gui.dock.station.stack.menu.CombinedMenuContentListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupCombinedMenuContent
implements CombinedMenuContent {
    private JPopupMenu menu;
    private List<CombinedMenuContentListener> listeners = new ArrayList<CombinedMenuContentListener>();

    public void addCombinedMenuContentListener(CombinedMenuContentListener combinedMenuContentListener) {
        this.listeners.add(combinedMenuContentListener);
    }

    public void removeCombinedMenuContentListener(CombinedMenuContentListener combinedMenuContentListener) {
        this.listeners.remove(combinedMenuContentListener);
    }

    protected CombinedMenuContentListener[] listeners() {
        return this.listeners.toArray(new CombinedMenuContentListener[this.listeners.size()]);
    }

    public void open(DockController dockController, Component component, int n, int n2, CombinedMenuContent.Item[] itemArray) {
        this.cancel();
        this.menu = new JPopupMenu();
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                PopupCombinedMenuContent.this.cancel();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        for (CombinedMenuContent.Item object : itemArray) {
            this.menu.add(new ItemAction(object));
        }
        this.menu.show(component, n, n2);
        for (CombinedMenuContentListener combinedMenuContentListener : this.listeners()) {
            combinedMenuContentListener.opened(this);
        }
    }

    public void cancel() {
        if (this.menu != null) {
            JPopupMenu jPopupMenu = this.menu;
            this.menu = null;
            jPopupMenu.setVisible(false);
            for (CombinedMenuContentListener combinedMenuContentListener : this.listeners()) {
                combinedMenuContentListener.canceled(this);
            }
        }
    }

    public void select(Dockable dockable) {
        if (this.menu != null) {
            JPopupMenu jPopupMenu = this.menu;
            this.menu = null;
            jPopupMenu.setVisible(false);
            for (CombinedMenuContentListener combinedMenuContentListener : this.listeners()) {
                combinedMenuContentListener.selected(this, dockable);
            }
        }
    }

    private class ItemAction
    extends AbstractAction {
        private Dockable dockable;

        public ItemAction(CombinedMenuContent.Item item) {
            this.dockable = item.getDockable();
            this.putValue("Name", item.getText());
            this.putValue("ShortDescription", item.getToolTip());
            this.putValue("SmallIcon", item.getIcon());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PopupCombinedMenuContent.this.select(this.dockable);
        }
    }
}

