/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.AbstractDockStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.screen.BoundaryRestriction;
import bibliothek.gui.dock.station.screen.DefaultScreenDockFullscreenStrategy;
import bibliothek.gui.dock.station.screen.DefaultScreenDockWindowFactory;
import bibliothek.gui.dock.station.screen.ScreenDockFullscreenStrategy;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.station.screen.ScreenDockStationFactory;
import bibliothek.gui.dock.station.screen.ScreenDockStationListener;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.ScreenDockWindowFactory;
import bibliothek.gui.dock.station.screen.ScreenDockWindowHandle;
import bibliothek.gui.dock.station.screen.ScreenDockWindowListener;
import bibliothek.gui.dock.station.screen.ScreenFullscreenAction;
import bibliothek.gui.dock.station.support.CombinerWrapper;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DisplayerFactoryWrapper;
import bibliothek.gui.dock.station.support.DockableVisibilityManager;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderMetaMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.StationPaintWrapper;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.PropertyFactory;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenDockStation
extends AbstractDockStation {
    public static final String TITLE_ID = "screen dock";
    public static final PropertyKey<BoundaryRestriction> BOUNDARY_RESTRICTION = new PropertyKey<BoundaryRestriction>("ScreenDockStation.boundary_restriction", new ConstantPropertyFactory<BoundaryRestriction>(BoundaryRestriction.FREE), true);
    public static final PropertyKey<ScreenDockWindowFactory> WINDOW_FACTORY = new PropertyKey<DefaultScreenDockWindowFactory>("ScreenDockStation.window_factory", new ConstantPropertyFactory<DefaultScreenDockWindowFactory>(new DefaultScreenDockWindowFactory()), true);
    public static final PropertyKey<ScreenDockFullscreenStrategy> FULL_SCREEN_STRATEGY = new PropertyKey<ScreenDockFullscreenStrategy>("ScreenDockStation.full_screen_strategy", new PropertyFactory<ScreenDockFullscreenStrategy>(){

        @Override
        public ScreenDockFullscreenStrategy getDefault(PropertyKey<ScreenDockFullscreenStrategy> propertyKey, DockProperties dockProperties) {
            return new DefaultScreenDockFullscreenStrategy();
        }

        @Override
        public ScreenDockFullscreenStrategy getDefault(PropertyKey<ScreenDockFullscreenStrategy> propertyKey) {
            return new DefaultScreenDockFullscreenStrategy();
        }
    }, true);
    public static final PropertyKey<Boolean> EXPAND_ON_DOUBLE_CLICK = new PropertyKey<Boolean>("ScreenDockStation.double_click_fullscreen", new ConstantPropertyFactory<Boolean>(true), true);
    private boolean showing = false;
    private PlaceholderList<ScreenDockWindowHandle> dockables = new PlaceholderList();
    private List<ScreenDockStationListener> screenDockStationListeners = new ArrayList<ScreenDockStationListener>();
    private DockTitleVersion version;
    private CombinerWrapper combiner = new CombinerWrapper();
    private DropInfo dropInfo;
    private WindowProvider owner;
    private StationPaintWrapper stationPaint = new StationPaintWrapper();
    private DisplayerFactoryWrapper displayerFactory = new DisplayerFactoryWrapper();
    private DisplayerCollection displayers;
    private ScreenDockWindow frontWindow;
    private DockableVisibilityManager visibility;
    private ListeningDockAction fullscreenAction;
    private PropertyValue<BoundaryRestriction> restriction = new PropertyValue<BoundaryRestriction>(BOUNDARY_RESTRICTION){

        @Override
        protected void valueChanged(BoundaryRestriction boundaryRestriction, BoundaryRestriction boundaryRestriction2) {
            ScreenDockStation.this.checkWindowBoundaries();
        }
    };
    private PropertyValue<ScreenDockWindowFactory> windowFactory = new PropertyValue<ScreenDockWindowFactory>(WINDOW_FACTORY){

        @Override
        protected void valueChanged(ScreenDockWindowFactory screenDockWindowFactory, ScreenDockWindowFactory screenDockWindowFactory2) {
        }
    };
    private PropertyValue<ScreenDockFullscreenStrategy> fullscreenStrategy = new PropertyValue<ScreenDockFullscreenStrategy>(FULL_SCREEN_STRATEGY){

        @Override
        protected void valueChanged(ScreenDockFullscreenStrategy screenDockFullscreenStrategy, ScreenDockFullscreenStrategy screenDockFullscreenStrategy2) {
            ArrayList<ScreenDockWindow> arrayList = new ArrayList<ScreenDockWindow>();
            for (ScreenDockWindowHandle object : ScreenDockStation.this.dockables.dockables()) {
                ScreenDockWindow screenDockWindow = object.getWindow();
                if (!screenDockWindow.isFullscreen()) continue;
                arrayList.add(screenDockWindow);
                screenDockWindow.setFullscreen(false);
            }
            if (screenDockFullscreenStrategy != null) {
                screenDockFullscreenStrategy.uninstall(ScreenDockStation.this);
            }
            if (screenDockFullscreenStrategy2 != null) {
                screenDockFullscreenStrategy2.install(ScreenDockStation.this);
            }
            for (ScreenDockWindowHandle screenDockWindowHandle : ScreenDockStation.this.dockables.dockables()) {
                screenDockWindowHandle.getWindow().setFullscreenStrategy(screenDockFullscreenStrategy2);
            }
            for (ScreenDockWindow screenDockWindow : arrayList) {
                screenDockWindow.setFullscreen(true);
            }
        }
    };
    private PropertyValue<Boolean> expandOnDoubleClick = new PropertyValue<Boolean>(EXPAND_ON_DOUBLE_CLICK){

        @Override
        protected void valueChanged(Boolean bl, Boolean bl2) {
            DockController dockController;
            if (bl.booleanValue() != bl2.booleanValue() && (dockController = ScreenDockStation.this.getController()) != null) {
                if (bl2.booleanValue()) {
                    dockController.getDoubleClickController().addListener(ScreenDockStation.this.doubleClickListener);
                } else {
                    dockController.getDoubleClickController().removeListener(ScreenDockStation.this.doubleClickListener);
                }
            }
        }
    };
    private PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy placeholderStrategy, PlaceholderStrategy placeholderStrategy2) {
            ScreenDockStation.this.dockables.setStrategy(placeholderStrategy2);
        }
    };
    private DoubleClickListener doubleClickListener = new DoubleClickListener(){

        public DockElement getTreeLocation() {
            return ScreenDockStation.this;
        }

        public boolean process(Dockable dockable, MouseEvent mouseEvent) {
            if (dockable != ScreenDockStation.this) {
                DockStation dockStation = dockable.getDockParent();
                while (dockStation != null && dockStation != ScreenDockStation.this) {
                    dockable = dockStation.asDockable();
                    dockStation = dockable == null ? null : dockable.getDockParent();
                }
                if (dockStation == ScreenDockStation.this) {
                    boolean bl = ScreenDockStation.this.isFullscreen(dockable);
                    ScreenDockStation.this.setFullscreen(dockable, !bl);
                    return true;
                }
            }
            return false;
        }
    };

    public ScreenDockStation(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        this.init(new DirectWindowProvider(window));
    }

    public ScreenDockStation(WindowProvider windowProvider) {
        if (windowProvider == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        this.init(windowProvider);
    }

    private void init(WindowProvider windowProvider) {
        this.visibility = new DockableVisibilityManager(this.listeners);
        this.owner = windowProvider;
        this.displayers = new DisplayerCollection(this, this.displayerFactory);
        this.fullscreenAction = this.createFullscreenAction();
        this.addScreenDockStationListener(new FullscreenListener());
    }

    protected ListeningDockAction createFullscreenAction() {
        return new ScreenFullscreenAction(this);
    }

    public void addScreenDockStationListener(ScreenDockStationListener screenDockStationListener) {
        this.screenDockStationListeners.add(screenDockStationListener);
    }

    public void removeScreenDockStationListener(ScreenDockStationListener screenDockStationListener) {
        this.screenDockStationListeners.remove(screenDockStationListener);
    }

    protected ScreenDockStationListener[] screenDockStationListeners() {
        return this.screenDockStationListeners.toArray(new ScreenDockStationListener[this.screenDockStationListeners.size()]);
    }

    public void setFullscreenAction(ListeningDockAction listeningDockAction) {
        if (this.fullscreenAction != null) {
            throw new IllegalStateException("The fullScreenAction can only be set once");
        }
        this.fullscreenAction = listeningDockAction;
    }

    @Override
    public DefaultDockActionSource getDirectActionOffers(Dockable dockable) {
        if (this.fullscreenAction == null) {
            return null;
        }
        DefaultDockActionSource defaultDockActionSource = new DefaultDockActionSource(new LocationHint(LocationHint.DIRECT_ACTION, LocationHint.VERY_RIGHT), new DockAction[0]);
        defaultDockActionSource.add(this.fullscreenAction);
        return defaultDockActionSource;
    }

    @Override
    public DockActionSource getIndirectActionOffers(Dockable dockable) {
        if (this.fullscreenAction == null) {
            return null;
        }
        DockStation dockStation = dockable.getDockParent();
        if (dockStation == null) {
            return null;
        }
        if (dockStation instanceof ScreenDockStation) {
            return null;
        }
        dockable = dockStation.asDockable();
        if (dockable == null) {
            return null;
        }
        dockStation = dockable.getDockParent();
        if (dockStation != this) {
            return null;
        }
        DefaultDockActionSource defaultDockActionSource = new DefaultDockActionSource(this.fullscreenAction);
        defaultDockActionSource.setHint(new LocationHint(LocationHint.INDIRECT_ACTION, LocationHint.VERY_RIGHT));
        return defaultDockActionSource;
    }

    public DisplayerFactoryWrapper getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    public CombinerWrapper getCombiner() {
        return this.combiner;
    }

    public StationPaintWrapper getPaint() {
        return this.stationPaint;
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new ScreenDockStationFactory(this.owner));
    }

    @Override
    public void setController(DockController dockController) {
        DockController dockController2 = this.getController();
        if (dockController2 != null) {
            if (this.expandOnDoubleClick.getValue().booleanValue()) {
                dockController2.getDoubleClickController().removeListener(this.doubleClickListener);
            }
            this.dockables.unbind();
        }
        this.version = null;
        super.setController(dockController);
        this.displayers.setController(dockController);
        if (dockController != null) {
            this.version = dockController.getDockTitleManager().getVersion(TITLE_ID, ControllerTitleFactory.INSTANCE);
            if (this.expandOnDoubleClick.getValue().booleanValue()) {
                dockController.getDoubleClickController().addListener(this.doubleClickListener);
            }
            this.dockables.bind();
        }
        this.restriction.setProperties(dockController);
        this.windowFactory.setProperties(dockController);
        this.fullscreenStrategy.setProperties(dockController);
        this.placeholderStrategy.setProperties(dockController);
        if (this.fullscreenAction != null) {
            this.fullscreenAction.setController(dockController);
        }
        for (ScreenDockWindowHandle screenDockWindowHandle : this.dockables.dockables()) {
            screenDockWindowHandle.getWindow().setController(dockController);
        }
    }

    @Override
    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    @Override
    public Dockable getDockable(int n) {
        return this.dockables.dockables().get(n).asDockable();
    }

    public int indexOf(Dockable dockable) {
        PlaceholderList.Filter<ScreenDockWindowHandle> filter = this.dockables.dockables();
        int n = filter.size();
        for (int i = 0; i < n; ++i) {
            ScreenDockWindowHandle screenDockWindowHandle = filter.get(i);
            if (screenDockWindowHandle.asDockable() != dockable) continue;
            return i;
        }
        return -1;
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    public PlaceholderMap getPlaceholders(final Map<Dockable, Integer> map) {
        final PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
        return this.dockables.toMap((PlaceholderListItemConverter<ScreenDockWindowHandle>)new PlaceholderListItemAdapter<ScreenDockWindowHandle>(){

            @Override
            public ConvertedPlaceholderListItem convert(int n, ScreenDockWindowHandle screenDockWindowHandle) {
                Path path;
                ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                Rectangle rectangle = screenDockWindowHandle.getBounds();
                convertedPlaceholderListItem.putInt("id", (Integer)map.get(screenDockWindowHandle.asDockable()));
                convertedPlaceholderListItem.putInt("x", rectangle.x);
                convertedPlaceholderListItem.putInt("y", rectangle.y);
                convertedPlaceholderListItem.putInt("width", rectangle.width);
                convertedPlaceholderListItem.putInt("height", rectangle.height);
                convertedPlaceholderListItem.putBoolean("fullscreen", screenDockWindowHandle.getWindow().isFullscreen());
                if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(screenDockWindowHandle.asDockable())) != null) {
                    convertedPlaceholderListItem.putString("placeholder", path.toString());
                    convertedPlaceholderListItem.setPlaceholder(path);
                }
                return convertedPlaceholderListItem;
            }
        });
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are children on this station");
        }
        try {
            PlaceholderList placeholderList = new PlaceholderList(placeholderMap);
            if (this.getController() != null) {
                this.dockables.setStrategy(null);
                this.dockables.unbind();
                this.dockables = placeholderList;
                this.dockables.bind();
                this.dockables.setStrategy(this.getPlaceholderStrategy());
            } else {
                this.dockables = placeholderList;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setPlaceholders(PlaceholderMap placeholderMap, final Map<Integer, Dockable> map) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("must not have any children");
        }
        PlaceholderList<ScreenDockWindowHandle> placeholderList = new PlaceholderList<ScreenDockWindowHandle>();
        if (this.getController() != null) {
            this.dockables.setStrategy(null);
            this.dockables.unbind();
            this.dockables = placeholderList;
            this.dockables.bind();
            this.dockables.setStrategy(this.getPlaceholderStrategy());
        } else {
            this.dockables = placeholderList;
        }
        placeholderList.read(placeholderMap, new PlaceholderListItemAdapter<ScreenDockWindowHandle>(){

            @Override
            public ScreenDockWindowHandle convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                int n = convertedPlaceholderListItem.getInt("id");
                Dockable dockable = (Dockable)map.get(n);
                if (dockable != null) {
                    int n2 = convertedPlaceholderListItem.getInt("x");
                    int n3 = convertedPlaceholderListItem.getInt("y");
                    int n4 = convertedPlaceholderListItem.getInt("width");
                    int n5 = convertedPlaceholderListItem.getInt("height");
                    boolean bl = convertedPlaceholderListItem.getBoolean("fullscreen");
                    ScreenDockStation.this.listeners.fireDockableAdding(dockable);
                    ScreenDockWindow screenDockWindow = ScreenDockStation.this.createWindow();
                    ScreenDockWindowHandle screenDockWindowHandle = new ScreenDockWindowHandle(dockable, screenDockWindow);
                    screenDockWindow.setController(ScreenDockStation.this.getController());
                    screenDockWindow.setFullscreenStrategy(ScreenDockStation.this.getFullscreenStrategy());
                    screenDockWindow.setDockable(dockable);
                    screenDockWindow.setWindowBounds(new Rectangle(n2, n3, n4, n5));
                    screenDockWindow.setVisible(ScreenDockStation.this.isShowing());
                    screenDockWindow.validate();
                    screenDockWindow.setFullscreen(bl);
                    return screenDockWindowHandle;
                }
                return null;
            }

            @Override
            public void added(ScreenDockWindowHandle screenDockWindowHandle) {
                screenDockWindowHandle.asDockable().setDockParent(ScreenDockStation.this);
                for (ScreenDockStationListener screenDockStationListener : ScreenDockStation.this.screenDockStationListeners()) {
                    screenDockStationListener.windowRegistering(ScreenDockStation.this, screenDockWindowHandle.asDockable(), screenDockWindowHandle.getWindow());
                }
                ScreenDockStation.this.listeners.fireDockableAdded(screenDockWindowHandle.asDockable());
            }
        });
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy.getValue();
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholderStrategy) {
        this.placeholderStrategy.setValue(placeholderStrategy);
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.frontWindow == null) {
            return null;
        }
        return this.frontWindow.getDockable();
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        Dockable dockable2;
        Dockable dockable3 = this.getFrontDockable();
        this.frontWindow = this.getWindow(dockable);
        if (this.frontWindow != null) {
            this.frontWindow.toFront();
        }
        if (dockable3 != (dockable2 = this.getFrontDockable())) {
            this.listeners.fireDockableSelected(dockable3, dockable2);
        }
    }

    @Override
    public boolean prepareDrop(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        return this.prepare(n, n2, n3, n4, dockable, true);
    }

    public boolean prepare(int n, int n2, int n3, int n4, Dockable dockable, boolean bl) {
        if (this.dropInfo == null) {
            this.dropInfo = new DropInfo();
        }
        ScreenDockWindow screenDockWindow = this.dropInfo.combine;
        this.dropInfo.titleX = n3;
        this.dropInfo.titleY = n4;
        this.dropInfo.dockable = dockable;
        this.dropInfo.combine = this.searchCombineDockable(n, n2, dockable);
        if (this.dropInfo.combine != null && this.dropInfo.combine.getDockable() == dockable) {
            this.dropInfo.combine = null;
        }
        if (this.dropInfo.combine != screenDockWindow) {
            if (screenDockWindow != null) {
                screenDockWindow.setPaintCombining(false);
            }
            if (this.dropInfo.combine != null) {
                this.dropInfo.combine.setPaintCombining(true);
            }
        }
        this.checkDropInfo();
        return this.dropInfo != null;
    }

    private void checkDropInfo() {
        if (this.dropInfo != null) {
            if (this.dropInfo.combine != null) {
                if (!(this.accept(this.dropInfo.dockable) && this.dropInfo.dockable.accept(this, this.dropInfo.combine.getDockable()) && this.dropInfo.combine.getDockable().accept(this, this.dropInfo.dockable) && this.getController().getAcceptance().accept(this, this.dropInfo.combine.getDockable(), this.dropInfo.dockable))) {
                    this.dropInfo = null;
                }
            } else if (!(this.accept(this.dropInfo.dockable) && this.dropInfo.dockable.accept(this) && this.getController().getAcceptance().accept(this, this.dropInfo.dockable))) {
                this.dropInfo = null;
            }
        }
    }

    protected ScreenDockWindow searchCombineDockable(int n, int n2, Dockable dockable) {
        MultiDockAcceptance multiDockAcceptance = this.getController() == null ? null : this.getController().getAcceptance();
        for (ScreenDockWindowHandle screenDockWindowHandle : this.dockables.dockables()) {
            ScreenDockWindow screenDockWindow = screenDockWindowHandle.getWindow();
            if (!screenDockWindow.inCombineArea(n, n2)) continue;
            Dockable dockable2 = screenDockWindow.getDockable();
            if (multiDockAcceptance != null && !multiDockAcceptance.accept(this, dockable2, dockable) || !dockable.accept(this, dockable2) || !dockable2.accept(this, dockable)) continue;
            return screenDockWindow;
        }
        return null;
    }

    @Override
    public void drop() {
        if (this.dropInfo.combine != null) {
            this.combine(this.dropInfo.combine.getDockable(), this.dropInfo.dockable);
        } else {
            Component component = this.dropInfo.dockable.getComponent();
            Rectangle rectangle = new Rectangle(this.dropInfo.titleX, this.dropInfo.titleY, component.getWidth(), component.getHeight());
            this.addDockable(this.dropInfo.dockable, rectangle, false);
        }
    }

    @Override
    public void drop(Dockable dockable) {
        Window window = this.getOwner();
        int n = 30;
        int n2 = 30;
        if (window != null) {
            n += window.getX();
            n2 += window.getY();
        }
        Dimension dimension = dockable.getComponent().getPreferredSize();
        Rectangle rectangle = new Rectangle(n, n2, Math.max(dimension.width, 100), Math.max(dimension.height, 100));
        this.addDockable(dockable, rectangle);
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable, Dockable dockable2) {
        return this.getLocation(dockable, dockable2);
    }

    public ScreenDockProperty getLocation(Dockable dockable, Dockable dockable2) {
        int n = this.indexOf(dockable);
        ScreenDockWindow screenDockWindow = this.getWindow(n);
        if (screenDockWindow == null) {
            throw new IllegalArgumentException("dockable not child of this station");
        }
        Rectangle rectangle = null;
        boolean bl = screenDockWindow.isFullscreen();
        if (bl) {
            rectangle = screenDockWindow.getNormalBounds();
        }
        if (rectangle == null) {
            rectangle = screenDockWindow.getWindowBounds();
        }
        PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
        Path path = null;
        if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(dockable2 == null ? dockable : dockable2)) != null) {
            this.dockables.dockables().addPlaceholder(n, path);
        }
        return new ScreenDockProperty(rectangle.x, rectangle.y, rectangle.width, rectangle.height, path, bl);
    }

    public ScreenDockWindow getWindow(Dockable dockable) {
        int n = this.indexOf(dockable);
        if (n < 0) {
            return null;
        }
        return this.getWindow(n);
    }

    public ScreenDockWindow getWindow(int n) {
        return this.getWindowHandle(n).getWindow();
    }

    private ScreenDockWindowHandle getWindowHandle(int n) {
        return this.dockables.dockables().get(n);
    }

    public Dockable[] getFullscreenChildren() {
        ArrayList<Dockable> arrayList = new ArrayList<Dockable>();
        for (ScreenDockWindowHandle screenDockWindowHandle : this.dockables.dockables()) {
            ScreenDockWindow screenDockWindow = screenDockWindowHandle.getWindow();
            if (!screenDockWindow.isFullscreen()) continue;
            arrayList.add(screenDockWindow.getDockable());
        }
        return arrayList.toArray(new Dockable[arrayList.size()]);
    }

    public boolean isFullscreen(Dockable dockable) {
        ScreenDockWindow screenDockWindow = this.getWindow(dockable);
        if (screenDockWindow == null) {
            throw new IllegalArgumentException("dockable is not known to this station");
        }
        return screenDockWindow.isFullscreen();
    }

    public void setFullscreen(Dockable dockable, boolean bl) {
        ScreenDockWindow screenDockWindow = this.getWindow(dockable);
        if (screenDockWindow == null) {
            throw new IllegalArgumentException("dockable is not known to this station");
        }
        screenDockWindow.setFullscreen(bl);
    }

    public void setExpandOnDoubleClick(boolean bl) {
        this.expandOnDoubleClick.setValue(bl);
    }

    public void clearExpandOnDoubleClick() {
        this.expandOnDoubleClick.setValue(null);
    }

    public boolean isExpandOnDoubleClick() {
        return this.expandOnDoubleClick.getValue();
    }

    @Override
    public boolean prepareMove(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        return this.prepare(n, n2, n3, n4, dockable, false);
    }

    @Override
    public void move() {
        if (this.dropInfo.combine != null) {
            this.combine(this.dropInfo.combine.getDockable(), this.dropInfo.dockable);
        } else {
            ScreenDockWindow screenDockWindow = this.getWindow(this.dropInfo.dockable);
            Point point = screenDockWindow.getOffsetMove();
            if (point == null) {
                point = new Point(0, 0);
            }
            Rectangle rectangle = screenDockWindow.getWindowBounds();
            rectangle = new Rectangle(this.dropInfo.titleX - point.x, this.dropInfo.titleY - point.y, rectangle.width, rectangle.height);
            screenDockWindow.setWindowBounds(rectangle);
        }
    }

    @Override
    public void move(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof ScreenDockProperty) {
            ScreenDockWindow screenDockWindow = this.getWindow(dockable);
            if (screenDockWindow == null) {
                throw new IllegalArgumentException("dockable not child of this station");
            }
            ScreenDockProperty screenDockProperty = (ScreenDockProperty)dockableProperty;
            screenDockWindow.setWindowBounds(new Rectangle(screenDockProperty.getX(), screenDockProperty.getY(), screenDockProperty.getWidth(), screenDockProperty.getHeight()));
        }
    }

    @Override
    public void draw() {
        if (this.dropInfo == null) {
            this.dropInfo = new DropInfo();
        }
        if (this.dropInfo.combine != null) {
            this.dropInfo.combine.setPaintCombining(true);
        }
    }

    @Override
    public void forget() {
        if (this.dropInfo != null) {
            if (this.dropInfo.combine != null) {
                this.dropInfo.combine.setPaintCombining(false);
            }
            this.dropInfo = null;
        }
    }

    @Override
    public <D extends Dockable & DockStation> boolean isInOverrideZone(int n, int n2, D d, Dockable dockable) {
        return this.searchCombineDockable(n, n2, dockable) != null;
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable can't be dragged, it is not child of this station");
        }
        this.removeDockable(dockable);
    }

    public void addDockable(Dockable dockable, Rectangle rectangle) {
        this.addDockable(dockable, rectangle, true);
    }

    public void addDockable(Dockable dockable, Rectangle rectangle, boolean bl) {
        this.addDockable(dockable, rectangle, null, bl);
    }

    protected void addDockable(Dockable dockable, Rectangle rectangle, Path path, boolean bl) {
        Cloneable cloneable;
        DockUtilities.ensureTreeValidity(this, dockable);
        if (rectangle == null) {
            throw new IllegalArgumentException("Bounds must not be null");
        }
        this.listeners.fireDockableAdding(dockable);
        ScreenDockWindow screenDockWindow = this.createWindow();
        this.register(dockable, path, screenDockWindow);
        screenDockWindow.setDockable(dockable);
        rectangle = new Rectangle(rectangle);
        if (!bl) {
            screenDockWindow.validate();
            cloneable = screenDockWindow.getDockableInsets();
            if (cloneable != null) {
                rectangle.x -= cloneable.left;
                rectangle.y -= cloneable.top;
                rectangle.width += cloneable.left + cloneable.right;
                rectangle.height += cloneable.top + cloneable.bottom;
            }
        }
        screenDockWindow.setWindowBounds(rectangle);
        screenDockWindow.validate();
        if (!bl) {
            screenDockWindow.validate();
            cloneable = screenDockWindow.getOffsetDrop();
            if (cloneable != null) {
                Rectangle rectangle2 = screenDockWindow.getWindowBounds();
                rectangle2 = new Rectangle(rectangle2.x + ((Point)cloneable).x, rectangle2.y + ((Point)cloneable).y, rectangle2.width, rectangle2.height);
                screenDockWindow.setWindowBounds(rectangle2);
            }
        }
        if (this.isShowing()) {
            screenDockWindow.setVisible(true);
        }
        dockable.setDockParent(this);
        this.listeners.fireDockableAdded(dockable);
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof ScreenDockProperty) {
            return this.drop(dockable, (ScreenDockProperty)dockableProperty);
        }
        return false;
    }

    public boolean drop(Dockable dockable, ScreenDockProperty screenDockProperty) {
        return this.drop(dockable, screenDockProperty, true);
    }

    public boolean drop(Dockable dockable, ScreenDockProperty screenDockProperty, boolean bl) {
        Object object;
        DockUtilities.ensureTreeValidity(this, dockable);
        ScreenDockWindow screenDockWindow = null;
        double d = 0.0;
        int n = screenDockProperty.getX();
        int n2 = screenDockProperty.getY();
        int n3 = screenDockProperty.getWidth();
        int n4 = screenDockProperty.getHeight();
        DockController dockController = this.getController();
        MultiDockAcceptance multiDockAcceptance = dockController == null ? null : dockController.getAcceptance();
        Path path = screenDockProperty.getPlaceholder();
        if (path != null) {
            ScreenDockWindowHandle screenDockWindowHandle = this.dockables.getDockableAt(path);
            if (screenDockWindowHandle != null) {
                d = 1.0;
                screenDockWindow = screenDockWindowHandle.getWindow();
            } else {
                object = this.dockables.getMetaMap(path);
                if (object != null) {
                    if (((PlaceholderMetaMap)object).contains("x")) {
                        n = ((PlaceholderMetaMap)object).getInt("x");
                    }
                    if (((PlaceholderMetaMap)object).contains("y")) {
                        n2 = ((PlaceholderMetaMap)object).getInt("y");
                    }
                    if (((PlaceholderMetaMap)object).contains("width")) {
                        n3 = ((PlaceholderMetaMap)object).getInt("width");
                    }
                    if (((PlaceholderMetaMap)object).contains("height")) {
                        n4 = ((PlaceholderMetaMap)object).getInt("height");
                    }
                    bl = true;
                } else {
                    path = null;
                }
            }
        }
        if (d == 0.0) {
            double d2 = n3 * n4;
            for (ScreenDockWindowHandle object2 : this.dockables.dockables()) {
                double d3;
                double d4;
                double d5;
                ScreenDockWindow screenDockWindow2 = object2.getWindow();
                if (screenDockWindow2.isFullscreen()) continue;
                Rectangle rectangle = screenDockWindow2.getWindowBounds();
                double d6 = rectangle.width * rectangle.height;
                rectangle = SwingUtilities.computeIntersection(n, n2, n3, n4, rectangle);
                if (rectangle.width == 0 || rectangle.height == 0 || !((d5 = (d4 = (double)(rectangle.width * rectangle.height)) / (d3 = Math.max(d2, d6))) > d)) continue;
                d = d3;
                screenDockWindow = screenDockWindow2;
            }
        }
        boolean bl2 = false;
        if (d > 0.75) {
            Dockable dockable2;
            DockStation dockStation;
            object = screenDockProperty.getSuccessor();
            Dockable dockable22 = screenDockWindow.getDockable();
            if (object != null && (dockStation = dockable22.asDockStation()) != null) {
                bl2 = dockStation.drop(dockable, (DockableProperty)object);
            }
            if (!bl2 && (dockable2 = screenDockWindow.getDockable()).accept(this, dockable) && dockable.accept(this, dockable2) && (multiDockAcceptance == null || multiDockAcceptance.accept(this, dockable2, dockable))) {
                this.combine(dockable2, dockable);
                bl2 = true;
            }
        }
        if (!bl2) {
            boolean bl3;
            boolean bl4 = bl3 = this.accept(dockable) && dockable.accept(this) && (multiDockAcceptance == null || multiDockAcceptance.accept(this, dockable));
            if (bl3) {
                this.addDockable(dockable, new Rectangle(n, n2, n3, n4), path, bl);
                bl2 = true;
            }
        }
        if (bl2 && screenDockProperty.isFullscreen()) {
            DockStation dockStation = dockable.getDockParent();
            while (dockStation != null && dockStation != this) {
                dockable = dockStation.asDockable();
                dockStation = dockable == null ? null : dockable.getDockParent();
            }
            if (dockable != null) {
                this.setFullscreen(dockable, true);
            }
        }
        return bl2;
    }

    public boolean drop(Dockable dockable, Dockable dockable2) {
        boolean bl;
        boolean bl2 = bl = this.accept(dockable) && dockable.accept(this);
        if (!bl) {
            return false;
        }
        ScreenDockWindow screenDockWindow = this.getWindow(dockable2);
        if (screenDockWindow == null) {
            throw new IllegalArgumentException("location is now known to this station");
        }
        Rectangle rectangle = null;
        if (screenDockWindow.isFullscreen()) {
            rectangle = screenDockWindow.getNormalBounds();
        }
        if (rectangle == null) {
            rectangle = screenDockWindow.getWindowBounds();
        }
        this.addDockable(dockable, rectangle, true);
        return true;
    }

    public void combine(Dockable dockable, Dockable dockable2) {
        int n = this.indexOf(dockable);
        if (n < 0) {
            throw new IllegalArgumentException("lower is not child of this station");
        }
        ScreenDockWindowHandle screenDockWindowHandle = this.getWindowHandle(n);
        this.removeDockable(dockable2);
        this.listeners.fireDockableRemoving(dockable);
        screenDockWindowHandle.setDockable(null);
        dockable.setDockParent(null);
        this.listeners.fireDockableRemoved(dockable);
        int n2 = this.dockables.levelToBase(n, PlaceholderList.Level.DOCKABLE);
        PlaceholderList.Item item = this.dockables.list().get(n2);
        PlaceholderMap placeholderMap = item.getPlaceholderMap();
        item.setPlaceholderMap(null);
        Dockable dockable3 = this.combiner.combine(dockable, dockable2, this, placeholderMap);
        this.listeners.fireDockableAdding(dockable3);
        screenDockWindowHandle.setDockable(dockable3);
        dockable3.setDockParent(this);
        this.listeners.fireDockableAdded(dockable3);
    }

    @Override
    public boolean canReplace(Dockable dockable, Dockable dockable2) {
        return true;
    }

    @Override
    public void replace(DockStation dockStation, Dockable dockable) {
        this.replace(dockStation.asDockable(), dockable, true);
    }

    @Override
    public void replace(Dockable dockable, Dockable dockable2) {
        this.replace(dockable, dockable2, false);
    }

    public void replace(Dockable dockable, Dockable dockable2, boolean bl) {
        int n = this.indexOf(dockable);
        if (n < 0) {
            throw new IllegalArgumentException("current not known to this station");
        }
        ScreenDockWindowHandle screenDockWindowHandle = this.getWindowHandle(n);
        if (bl) {
            int n2 = this.dockables.levelToBase(n, PlaceholderList.Level.DOCKABLE);
            PlaceholderList.Item item = this.dockables.list().get(n2);
            item.setPlaceholderMap(dockable.asDockStation().getPlaceholders());
        }
        this.listeners.fireDockableRemoving(dockable);
        screenDockWindowHandle.setDockable(null);
        dockable.setDockParent(null);
        this.listeners.fireDockableRemoved(dockable);
        this.listeners.fireDockableAdding(dockable2);
        screenDockWindowHandle.setDockable(dockable2);
        dockable2.setDockParent(this);
        this.listeners.fireDockableAdded(dockable2);
    }

    public void removeDockable(Dockable dockable) {
        int n = this.indexOf(dockable);
        if (n >= 0) {
            this.removeDockable(n);
        }
    }

    public void removeDockable(int n) {
        ScreenDockWindowHandle screenDockWindowHandle = this.getWindowHandle(n);
        ScreenDockWindow screenDockWindow = screenDockWindowHandle.getWindow();
        Dockable dockable = screenDockWindow.getDockable();
        this.listeners.fireDockableRemoving(dockable);
        screenDockWindow.setVisible(false);
        screenDockWindowHandle.setDockable(null);
        this.deregister(dockable, screenDockWindow);
        dockable.setDockParent(null);
        this.listeners.fireDockableRemoved(dockable);
    }

    protected ScreenDockWindowHandle register(Dockable dockable, Path path, ScreenDockWindow screenDockWindow) {
        ScreenDockWindowHandle screenDockWindowHandle = new ScreenDockWindowHandle(dockable, screenDockWindow);
        if (path != null) {
            if (this.dockables.getDockableAt(path) != null) {
                throw new IllegalStateException("there is already a window in the group " + path + ", add the element directly to that window or do not use a placeholder");
            }
            if (this.dockables.put(path, screenDockWindowHandle) == -1) {
                this.dockables.dockables().add(screenDockWindowHandle);
            }
        } else {
            this.dockables.dockables().add(screenDockWindowHandle);
        }
        screenDockWindow.setController(this.getController());
        screenDockWindow.setFullscreenStrategy(this.getFullscreenStrategy());
        for (ScreenDockStationListener screenDockStationListener : this.screenDockStationListeners()) {
            screenDockStationListener.windowRegistering(this, dockable, screenDockWindow);
        }
        return screenDockWindowHandle;
    }

    protected void deregister(Dockable dockable, ScreenDockWindow screenDockWindow) {
        if (this.frontWindow == screenDockWindow) {
            this.frontWindow = null;
        }
        int n = this.indexOf(screenDockWindow.getDockable());
        PlaceholderMetaMap placeholderMetaMap = this.dockables.dockables().getMetaMap(n);
        Rectangle rectangle = null;
        if (screenDockWindow.isFullscreen()) {
            rectangle = screenDockWindow.getNormalBounds();
        }
        if (rectangle == null) {
            rectangle = screenDockWindow.getWindowBounds();
        }
        placeholderMetaMap.putInt("x", rectangle.x);
        placeholderMetaMap.putInt("y", rectangle.y);
        placeholderMetaMap.putInt("width", rectangle.width);
        placeholderMetaMap.putInt("height", rectangle.height);
        this.dockables.remove(n);
        screenDockWindow.setController(null);
        screenDockWindow.setFullscreenStrategy(null);
        for (ScreenDockStationListener screenDockStationListener : this.screenDockStationListeners()) {
            screenDockStationListener.windowDeregistering(this, dockable, screenDockWindow);
        }
        screenDockWindow.destroy();
    }

    protected ScreenDockWindow createWindow() {
        return this.getWindowFactory().createWindow(this);
    }

    public Window getOwner() {
        return this.owner.searchWindow();
    }

    public WindowProvider getProvider() {
        return this.owner;
    }

    public ScreenDockWindowFactory getWindowFactory() {
        return this.windowFactory.getValue();
    }

    protected PropertyValue<ScreenDockWindowFactory> getWindowFactoryProperty() {
        return this.windowFactory;
    }

    public void setWindowFactory(ScreenDockWindowFactory screenDockWindowFactory) {
        this.windowFactory.setValue(screenDockWindowFactory);
    }

    public ScreenDockFullscreenStrategy getFullscreenStrategy() {
        return this.fullscreenStrategy.getValue();
    }

    public void setFullscreenStrategy(ScreenDockFullscreenStrategy screenDockFullscreenStrategy) {
        this.fullscreenStrategy.setValue(screenDockFullscreenStrategy);
    }

    public boolean isShowing() {
        return this.showing;
    }

    public void setShowing(boolean bl) {
        if (this.showing != bl) {
            this.showing = bl;
            for (ScreenDockWindowHandle screenDockWindowHandle : this.dockables.dockables()) {
                screenDockWindowHandle.getWindow().setVisible(bl);
            }
            this.visibility.fire();
        }
    }

    @Override
    public Rectangle getStationBounds() {
        return null;
    }

    @Override
    public Dockable asDockable() {
        return null;
    }

    @Override
    public DockStation asDockStation() {
        return this;
    }

    @Override
    public String getFactoryID() {
        return TITLE_ID;
    }

    @Override
    public boolean canCompare(DockStation dockStation) {
        return true;
    }

    @Override
    public int compare(DockStation dockStation) {
        return -1;
    }

    public DockTitleVersion getTitleVersion() {
        return this.version;
    }

    public BoundaryRestriction getBoundaryRestriction() {
        return this.restriction.getValue();
    }

    public void setBoundaryRestriction(BoundaryRestriction boundaryRestriction) {
        this.restriction.setValue(boundaryRestriction);
    }

    public void checkWindowBoundaries() {
        for (ScreenDockWindowHandle screenDockWindowHandle : this.dockables.dockables()) {
            screenDockWindowHandle.getWindow().checkWindowBounds();
        }
    }

    private class FullscreenListener
    implements ScreenDockStationListener,
    ScreenDockWindowListener {
        private FullscreenListener() {
        }

        public void fullscreenChanged(ScreenDockStation screenDockStation, Dockable dockable) {
        }

        public void windowDeregistering(ScreenDockStation screenDockStation, Dockable dockable, ScreenDockWindow screenDockWindow) {
            screenDockWindow.removeScreenDockWindowListener(this);
        }

        public void windowRegistering(ScreenDockStation screenDockStation, Dockable dockable, ScreenDockWindow screenDockWindow) {
            screenDockWindow.addScreenDockWindowListener(this);
        }

        public void fullscreenStateChanged(ScreenDockWindow screenDockWindow) {
            Dockable dockable = screenDockWindow.getDockable();
            if (dockable != null) {
                for (ScreenDockStationListener screenDockStationListener : ScreenDockStation.this.screenDockStationListeners()) {
                    screenDockStationListener.fullscreenChanged(ScreenDockStation.this, dockable);
                }
            }
        }

        public void shapeChanged(ScreenDockWindow screenDockWindow) {
        }

        public void visibilityChanged(ScreenDockWindow screenDockWindow) {
        }
    }

    private static class DropInfo {
        public Dockable dockable;
        public int titleX;
        public int titleY;
        public ScreenDockWindow combine;

        private DropInfo() {
        }
    }
}

