/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.displayer;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.TitleBarObserver;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentRepresentative;
import bibliothek.gui.dock.station.stack.TabContent;
import bibliothek.gui.dock.station.stack.TabContentFilterListener;
import bibliothek.gui.dock.station.stack.tab.TabContentFilter;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class EclipseDockableDisplayer
extends EclipseTabPane
implements DockableDisplayer {
    private DockStation station;
    private Dockable dockable;
    private DockTitle title;
    private DockableDisplayer.Location location;
    private List<DockableDisplayerListener> listeners = new ArrayList<DockableDisplayerListener>();
    private TitleBarObserver observer;
    private StackDockComponentRepresentative representative;
    private PropertyValue<TabPlacement> tabPlacement = new PropertyValue<TabPlacement>(StackDockStation.TAB_PLACEMENT){

        @Override
        protected void valueChanged(TabPlacement tabPlacement, TabPlacement tabPlacement2) {
            EclipseDockableDisplayer.this.setTabPlacement(tabPlacement2);
        }
    };
    private PropertyValue<TabContentFilter> filter = new PropertyValue<TabContentFilter>(StackDockStation.TAB_CONTENT_FILTER){

        @Override
        protected void valueChanged(TabContentFilter tabContentFilter, TabContentFilter tabContentFilter2) {
            if (tabContentFilter != null) {
                tabContentFilter.uninstall(EclipseDockableDisplayer.this);
                tabContentFilter.removeListener(EclipseDockableDisplayer.this.filterListener);
            }
            if (tabContentFilter2 != null) {
                tabContentFilter2.install(EclipseDockableDisplayer.this);
                tabContentFilter2.addListener(EclipseDockableDisplayer.this.filterListener);
            }
            EclipseDockableDisplayer.this.updateTabContent();
        }
    };
    private DockableListener dockableListener = new DockableAdapter(){

        public void titleTextChanged(Dockable dockable, String string, String string2) {
            EclipseDockableDisplayer.this.updateTabContent();
        }

        public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
            EclipseDockableDisplayer.this.updateTabContent();
        }

        public void titleToolTipChanged(Dockable dockable, String string, String string2) {
            EclipseDockableDisplayer.this.updateTabContent();
        }
    };
    private TabContentFilterListener filterListener = new TabContentFilterListener(){

        public void contentChanged() {
            EclipseDockableDisplayer.this.updateTabContent();
        }

        public void contentChanged(StackDockComponent stackDockComponent) {
            if (stackDockComponent == EclipseDockableDisplayer.this) {
                EclipseDockableDisplayer.this.updateTabContent();
            }
        }

        public void contentChanged(StackDockStation stackDockStation) {
        }

        public void contentChanged(Dockable dockable) {
            if (dockable == EclipseDockableDisplayer.this.dockable) {
                EclipseDockableDisplayer.this.updateTabContent();
            }
        }
    };

    public EclipseDockableDisplayer(EclipseTheme eclipseTheme, DockStation dockStation, Dockable dockable) {
        super(eclipseTheme, dockStation);
        this.observer = new TitleBarObserver(dockable, EclipseThemeConnector.TitleBar.ECLIPSE){

            protected void invalidated() {
                for (DockableDisplayerListener dockableDisplayerListener : EclipseDockableDisplayer.this.displayerListeners()) {
                    dockableDisplayerListener.discard(EclipseDockableDisplayer.this);
                }
            }
        };
        this.station = dockStation;
        this.representative = new StackDockComponentRepresentative();
        this.representative.setComponent(this);
        this.setDockable(dockable);
        this.getComponent().setFocusCycleRoot(true);
    }

    public Dimension getMinimumSize() {
        if (this.dockable == null) {
            return new Dimension(10, 10);
        }
        return this.dockable.getComponent().getMinimumSize();
    }

    public Dimension getPreferredSize() {
        if (this.dockable == null) {
            return new Dimension(10, 10);
        }
        return this.dockable.getComponent().getMinimumSize();
    }

    public void addDockableDisplayerListener(DockableDisplayerListener dockableDisplayerListener) {
        this.listeners.add(dockableDisplayerListener);
    }

    public void removeDockableDisplayerListener(DockableDisplayerListener dockableDisplayerListener) {
        this.listeners.remove(dockableDisplayerListener);
    }

    protected DockableDisplayerListener[] displayerListeners() {
        return this.listeners.toArray(new DockableDisplayerListener[this.listeners.size()]);
    }

    public void setDockable(Dockable dockable) {
        if (this.dockable != null) {
            this.removeAll();
            this.dockable.removeDockableListener(this.dockableListener);
        }
        this.dockable = dockable;
        if (dockable != null) {
            TabContent tabContent = new TabContent(dockable.getTitleIcon(), dockable.getTitleText(), dockable.getTitleToolTip());
            TabContentFilter tabContentFilter = this.filter.getValue();
            if (tabContentFilter != null) {
                tabContent = tabContentFilter.filter(tabContent, this, dockable);
            }
            if (tabContent == null) {
                this.addTab(null, null, dockable.getComponent(), dockable);
                this.setTooltipAt(0, null);
            } else {
                this.addTab(tabContent.getTitle(), tabContent.getIcon(), dockable.getComponent(), dockable);
                this.setTooltipAt(0, tabContent.getTooltip());
            }
            dockable.addDockableListener(this.dockableListener);
        }
        if (this.observer != null) {
            this.observer.setDockable(dockable);
        }
        this.representative.setTarget(dockable);
        this.revalidate();
    }

    private void updateTabContent() {
        if (this.dockable != null && this.getTabCount() == 1) {
            TabContent tabContent = new TabContent(this.dockable.getTitleIcon(), this.dockable.getTitleText(), this.dockable.getTitleToolTip());
            TabContentFilter tabContentFilter = this.filter.getValue();
            if (tabContentFilter != null) {
                tabContent = tabContentFilter.filter(tabContent, this, this.dockable);
            }
            if (tabContent == null) {
                this.setTitleAt(0, null);
                this.setIconAt(0, null);
                this.setTooltipAt(0, null);
            } else {
                this.setTitleAt(0, tabContent.getTitle());
                this.setIconAt(0, tabContent.getIcon());
                this.setTooltipAt(0, tabContent.getTooltip());
            }
        }
    }

    public void setController(DockController dockController) {
        super.setController(dockController);
        if (this.observer != null) {
            this.observer.setController(dockController);
        }
        this.tabPlacement.setProperties(dockController);
        this.filter.setProperties(dockController);
        this.representative.setController(dockController);
    }

    public boolean titleContains(int n, int n2) {
        Point point = new Point(n, n2);
        int n3 = this.getTabCount();
        for (int i = 0; i < n3; ++i) {
            Rectangle rectangle = this.getBoundsAt(i);
            if (!rectangle.contains(point)) continue;
            return true;
        }
        return false;
    }

    public Insets getDockableInsets() {
        return this.getContentInsets();
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public DockStation getStation() {
        return this.station;
    }

    public DockTitle getTitle() {
        return this.title;
    }

    public DockableDisplayer.Location getTitleLocation() {
        return this.location;
    }

    public void setStation(DockStation dockStation) {
        this.station = dockStation;
    }

    public void setTitle(DockTitle dockTitle) {
        this.title = dockTitle;
    }

    public void setTitleLocation(DockableDisplayer.Location location) {
        this.location = location;
    }
}

