/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.AbstractPreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceModelListener;
import bibliothek.util.Path;
import bibliothek.util.PathCombiner;
import java.util.ArrayList;
import java.util.List;

public class MergedPreferenceModel
extends AbstractPreferenceModel {
    private List<Model> models = new ArrayList<Model>();
    private PathCombiner combiner = PathCombiner.UNIQUE;
    private PreferenceModelListener listener = new PreferenceModelListener(){

        public void preferenceAdded(PreferenceModel preferenceModel, int n, int n2) {
            int n3 = MergedPreferenceModel.this.indexAt(preferenceModel, n);
            int n4 = n3 + (n2 - n);
            MergedPreferenceModel.this.firePreferenceAdded(n3, n4);
        }

        public void preferenceChanged(PreferenceModel preferenceModel, int n, int n2) {
            int n3 = MergedPreferenceModel.this.indexAt(preferenceModel, n);
            int n4 = n3 + (n2 - n);
            MergedPreferenceModel.this.firePreferenceChanged(n3, n4);
        }

        public void preferenceRemoved(PreferenceModel preferenceModel, int n, int n2) {
            int n3 = MergedPreferenceModel.this.indexAt(preferenceModel, n);
            int n4 = n3 + (n2 - n);
            MergedPreferenceModel.this.firePreferenceRemoved(n3, n4);
        }
    };

    public MergedPreferenceModel() {
    }

    public MergedPreferenceModel(PathCombiner pathCombiner) {
        if (pathCombiner == null) {
            throw new IllegalArgumentException("combiner must not be null");
        }
        this.combiner = pathCombiner;
    }

    public void add(PreferenceModel preferenceModel, Path path) {
        this.insert(this.models.size(), preferenceModel, path);
    }

    public void insert(int n, PreferenceModel preferenceModel, Path path) {
        int n2;
        if (this == preferenceModel) {
            throw new IllegalArgumentException("model must not be this");
        }
        for (Model model : this.models) {
            if (model.model == preferenceModel) {
                throw new IllegalArgumentException("can't add a model twice");
            }
            if (!model.path.equals(path)) continue;
            throw new IllegalArgumentException("there is already a model with the path " + path);
        }
        Model model = new Model();
        model.model = preferenceModel;
        model.path = path;
        this.models.add(n, model);
        if (this.hasListeners()) {
            preferenceModel.addPreferenceModelListener(this.listener);
        }
        if ((n2 = preferenceModel.getSize()) > 0) {
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                n3 += this.models.get((int)i).model.getSize();
            }
            this.firePreferenceAdded(n3, n3 + n2 - 1);
        }
    }

    public void remove(int n) {
        int n2;
        Model model = this.models.remove(n);
        if (this.hasListeners()) {
            model.model.removePreferenceModelListener(this.listener);
        }
        if ((n2 = model.model.getSize()) > 0) {
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                n3 += this.models.get((int)i).model.getSize();
            }
            this.firePreferenceRemoved(n3, n3 + n2 - 1);
        }
    }

    public void remove(MergedPreferenceModel mergedPreferenceModel) {
        int n = this.indexOf(mergedPreferenceModel);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public void remove(Path path) {
        int n = this.indexOf(path);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public void clear() {
        int n = this.getSize();
        if (this.hasListeners()) {
            for (Model model : this.models) {
                model.model.removePreferenceModelListener(this.listener);
            }
        }
        this.models.clear();
        if (n > 0) {
            this.firePreferenceRemoved(0, n - 1);
        }
    }

    public int indexOf(PreferenceModel preferenceModel) {
        int n = 0;
        for (Model model : this.models) {
            if (model.model == preferenceModel) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(Path path) {
        int n = 0;
        for (Model model : this.models) {
            if (model.path.equals(path)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public PreferenceModel getModel(int n) {
        return this.models.get((int)n).model;
    }

    public void read() {
        for (Model model : this.models) {
            model.model.read();
        }
    }

    public void write() {
        for (Model model : this.models) {
            model.model.write();
        }
    }

    public void addPreferenceModelListener(PreferenceModelListener preferenceModelListener) {
        boolean bl = this.hasListeners();
        super.addPreferenceModelListener(preferenceModelListener);
        if (this.hasListeners() && !bl) {
            for (Model model : this.models) {
                model.model.addPreferenceModelListener(this.listener);
            }
        }
    }

    public void removePreferenceModelListener(PreferenceModelListener preferenceModelListener) {
        boolean bl = this.hasListeners();
        super.removePreferenceModelListener(preferenceModelListener);
        if (!this.hasListeners() && bl) {
            for (Model model : this.models) {
                model.model.removePreferenceModelListener(this.listener);
            }
        }
    }

    public int getSize() {
        int n = 0;
        for (Model model : this.models) {
            n += model.model.getSize();
        }
        return n;
    }

    public String getLabel(int n) {
        Index index = this.indexAt(n);
        if (index == null) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return index.model.model.getLabel(index.index);
    }

    public String getDescription(int n) {
        Index index = this.indexAt(n);
        if (index == null) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return index.model.model.getDescription(index.index);
    }

    public Object getValueInfo(int n) {
        Index index = this.indexAt(n);
        if (index == null) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return index.model.model.getValueInfo(index.index);
    }

    public Object getValue(int n) {
        Index index = this.indexAt(n);
        if (index == null) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return index.model.model.getValue(index.index);
    }

    public void setValue(int n, Object object) {
        Index index = this.indexAt(n);
        if (index == null) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        index.model.model.setValue(index.index, object);
    }

    public Path getTypePath(int n) {
        Index index = this.indexAt(n);
        if (index == null) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return index.model.model.getTypePath(index.index);
    }

    public Path getPath(int n) {
        Index index = this.indexAt(n);
        if (index == null) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.combiner.combine(index.model.path, index.model.model.getPath(index.index));
    }

    public boolean isNatural(int n) {
        Index index = this.indexAt(n);
        if (index == null) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return index.model.model.isNatural(index.index);
    }

    public void setValueNatural(int n) {
        Index index = this.indexAt(n);
        if (index == null) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        index.model.model.setValueNatural(index.index);
    }

    protected Index indexAt(int n) {
        for (Model model : this.models) {
            int n2 = model.model.getSize();
            if (n < n2) {
                return new Index(model, n);
            }
            n -= n2;
        }
        return null;
    }

    protected int indexAt(PreferenceModel preferenceModel, int n) {
        for (Model model : this.models) {
            if (model.model == preferenceModel) {
                return n;
            }
            n += model.model.getSize();
        }
        return n;
    }

    private static class Model {
        public PreferenceModel model;
        public Path path;

        private Model() {
        }
    }

    protected static class Index {
        public Model model;
        public int index;

        public Index(Model model, int n) {
            this.model = model;
            this.index = n;
        }
    }
}

