/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.action;

import bibliothek.gui.DockController;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DefaultDockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.event.IconManagerListener;
import bibliothek.gui.dock.support.util.Resources;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class RenameAction
extends SimpleButtonAction {
    public static final String KEY_ICON = "rename";
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JTextField titleField = new JTextField();
    private JPopupMenu menu = new JPopupMenu();
    private Dockable current;

    public RenameAction(DockController dockController) {
        dockController.getIcons().setIconDefault(KEY_ICON, Resources.getIcon(KEY_ICON));
        dockController.getIcons().add(KEY_ICON, new IconManagerListener(){

            public void iconChanged(String string, Icon icon) {
                RenameAction.this.setIcon(icon);
            }
        });
        this.setIcon(dockController.getIcons().getIcon(KEY_ICON));
        ResourceBundle resourceBundle = Resources.getBundle();
        this.setText(resourceBundle.getString(KEY_ICON));
        this.setTooltip(resourceBundle.getString("rename.tooltip"));
        this.menu.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        this.menu.add((Component)this.titleField, new GridBagConstraints(0, 0, 1, 1, 100.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.menu.add((Component)jPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 3, new Insets(1, 1, 1, 1), 0, 0));
        this.titleField.setColumns(10);
        this.okButton.setText(DockUI.getDefaultDockUI().getString("rename.ok"));
        this.cancelButton.setText(DockUI.getDefaultDockUI().getString("rename.cancel"));
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                RenameAction.this.current = null;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RenameAction.this.rename();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RenameAction.this.menu.setVisible(false);
            }
        });
        this.titleField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RenameAction.this.rename();
            }
        });
    }

    public void action(Dockable dockable) {
        this.titleField.setText("");
        this.menu.setSize(this.menu.getPreferredSize());
        this.titleField.setText(dockable.getTitleText());
        Component component = DockUtilities.getShowingComponent(dockable);
        if (component != null) {
            this.current = dockable;
            this.menu.show(component, 0, 0);
            this.titleField.requestFocus();
        }
    }

    private void rename() {
        this.rename(this.current, this.titleField.getText());
        this.menu.setVisible(false);
    }

    protected abstract void rename(Dockable var1, String var2);

    public static class RenameDefaultDockable
    extends RenameAction {
        public RenameDefaultDockable(DockController dockController) {
            super(dockController);
        }

        protected void rename(Dockable dockable, String string) {
            ((DefaultDockable)dockable).setTitleText(string);
        }
    }

    public static class RenameFlapDockStation
    extends RenameAction {
        public RenameFlapDockStation(DockController dockController) {
            super(dockController);
        }

        protected void rename(Dockable dockable, String string) {
            ((FlapDockStation)dockable).setTitleText(string);
        }
    }

    public static class RenameSplitDockStation
    extends RenameAction {
        public RenameSplitDockStation(DockController dockController) {
            super(dockController);
        }

        protected void rename(Dockable dockable, String string) {
            ((SplitDockStation)dockable).setTitleText(string);
        }
    }

    public static class RenameStackDockStation
    extends RenameAction {
        public RenameStackDockStation(DockController dockController) {
            super(dockController);
        }

        protected void rename(Dockable dockable, String string) {
            ((StackDockStation)dockable).setTitleText(string);
        }
    }
}

