/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.menu;

import bibliothek.extension.gui.dock.preference.DefaultPreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceDialog;
import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceTreeDialog;
import bibliothek.extension.gui.dock.preference.PreferenceTreeModel;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CPreferenceModel;
import bibliothek.gui.dock.support.menu.BaseMenuPiece;
import bibliothek.gui.dock.support.util.Resources;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

public class CPreferenceMenuPiece
extends BaseMenuPiece {
    private CControl control;
    private PreferenceModel model;
    private AbstractAction action = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            CPreferenceMenuPiece.this.action();
        }
    };

    public static CPreferenceMenuPiece setup(CControl cControl) {
        if (cControl.getPreferenceModel() == null) {
            cControl.setPreferenceModel(new CPreferenceModel(cControl));
        }
        return new CPreferenceMenuPiece(cControl);
    }

    public CPreferenceMenuPiece(CControl cControl) {
        if (cControl == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        this.control = cControl;
        this.action.putValue("Name", Resources.getBundle().getString("PreferenceMenuPiece.text"));
        this.add(new JMenuItem(this.action));
    }

    public void setModel(PreferenceModel preferenceModel) {
        this.model = preferenceModel;
    }

    public PreferenceModel getModel() {
        return this.model;
    }

    protected void action() {
        PreferenceModel preferenceModel = this.model;
        if (preferenceModel == null) {
            preferenceModel = this.control.getPreferenceModel();
        }
        if (preferenceModel == null) {
            preferenceModel = new DefaultPreferenceModel();
        }
        Window window = this.control.intern().getController().findRootWindow();
        this.control.getPreferences().load(preferenceModel, false);
        if (preferenceModel instanceof PreferenceTreeModel) {
            PreferenceTreeDialog.openDialog((PreferenceTreeModel)preferenceModel, window);
        } else {
            PreferenceDialog.openDialog(preferenceModel, window);
        }
        this.control.getPreferences().store(preferenceModel);
    }
}

