/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.common.action.CAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CActionSource
extends AbstractDockActionSource {
    private List<CAction> actions = new ArrayList<CAction>();
    private LocationHint hint;

    public CActionSource(LocationHint locationHint) {
        if (locationHint == null) {
            throw new IllegalArgumentException("hint must not be null");
        }
        this.hint = locationHint;
    }

    public void add(CAction cAction) {
        this.insert(this.getDockActionCount(), cAction);
    }

    public void insert(int n, CAction cAction) {
        if (cAction == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        this.actions.add(n, cAction);
        this.fireAdded(n, n);
    }

    public CAction set(int n, CAction cAction) {
        if (cAction == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        if (n == this.actions.size()) {
            this.add(cAction);
            return null;
        }
        CAction cAction2 = this.remove(n);
        this.insert(n, cAction);
        return cAction2;
    }

    public CAction remove(int n) {
        CAction cAction = this.actions.remove(n);
        this.fireRemoved(n, n);
        return cAction;
    }

    public boolean remove(CAction cAction) {
        int n = this.actions.indexOf(cAction);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public CAction getAction(int n) {
        return this.actions.get(n);
    }

    @Override
    public DockAction getDockAction(int n) {
        return this.getAction(n).intern();
    }

    @Override
    public int getDockActionCount() {
        return this.actions.size();
    }

    @Override
    public LocationHint getLocationHint() {
        return this.hint;
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private int index = 0;
            private boolean removed = false;

            @Override
            public boolean hasNext() {
                return this.index < CActionSource.this.getDockActionCount();
            }

            @Override
            public DockAction next() {
                this.removed = false;
                return CActionSource.this.getDockAction(this.index++);
            }

            @Override
            public void remove() {
                if (this.removed) {
                    throw new IllegalStateException("item already removed");
                }
                this.removed = true;
                CActionSource.this.remove(this.index--);
            }
        };
    }
}

