/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.actions.SimpleDockAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.common.action.panel.DialogWindow;
import bibliothek.gui.dock.common.action.panel.MenuWindow;
import bibliothek.gui.dock.common.action.panel.PanelPopupWindow;
import bibliothek.gui.dock.common.action.panel.PanelPopupWindowListener;
import bibliothek.gui.dock.common.intern.action.CDecorateableAction;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class CPanelPopup
extends CDecorateableAction {
    public static final ActionType<PanelPopup> PANEL_POPUP = new ActionType("panel popup");
    private MenuBehavior menu = MenuBehavior.UNDECORATED_DIALOG;
    private ButtonBehavior button = ButtonBehavior.OPEN_ON_CLICK;
    private JComponent content;
    private PanelPopupWindow window;
    private boolean closeOnFocusLost = true;
    private PanelPopupWindowListener listener = new PanelPopupWindowListener(){

        public void closed(PanelPopupWindow panelPopupWindow) {
            panelPopupWindow.removeListener(CPanelPopup.this.listener);
            panelPopupWindow = null;
        }
    };

    public CPanelPopup() {
        super(null);
        this.init(new PanelPopup());
    }

    public void setContent(JComponent jComponent) {
        this.content = jComponent;
    }

    public JComponent getContent() {
        return this.content;
    }

    public void setMenuBehavior(MenuBehavior menuBehavior) {
        if (menuBehavior == null) {
            throw new IllegalArgumentException("menu must not be null");
        }
        this.menu = menuBehavior;
    }

    public MenuBehavior getMenuBehavior() {
        return this.menu;
    }

    public void setButtonBehavior(ButtonBehavior buttonBehavior) {
        if (buttonBehavior == null) {
            throw new IllegalArgumentException("button must not be null");
        }
        this.button = buttonBehavior;
    }

    public ButtonBehavior getButtonBehavior() {
        return this.button;
    }

    public void setCloseOnFocusLost(boolean bl) {
        this.closeOnFocusLost = bl;
    }

    public boolean isCloseOnFocusLost() {
        return this.closeOnFocusLost;
    }

    public void openPopup(PanelPopupWindow panelPopupWindow) {
        if (!panelPopupWindow.isOpen()) {
            throw new IllegalArgumentException("window is not open");
        }
        this.closePopup();
        this.window = panelPopupWindow;
        this.window.addListener(this.listener);
    }

    public void closePopup() {
        if (this.window != null) {
            this.window.close();
        }
    }

    public boolean isOpen() {
        return this.window != null && this.window.isOpen();
    }

    protected void onMousePressed(JComponent jComponent, DockTitle.Orientation orientation) {
        if (this.getButtonBehavior() == ButtonBehavior.OPEN_ON_PRESS) {
            this.openDialog(jComponent, orientation);
        }
    }

    protected void onMouseReleased(JComponent jComponent, DockTitle.Orientation orientation) {
        if (this.getButtonBehavior() == ButtonBehavior.OPEN_ON_CLICK) {
            this.openDialog(jComponent, orientation);
        }
    }

    protected void onTrigger(JComponent jComponent, DockTitle.Orientation orientation) {
        this.openDialog(jComponent, orientation);
    }

    protected void openDialog(JComponent jComponent, DockTitle.Orientation orientation) {
        if (this.isOpen() || this.content == null) {
            return;
        }
        Point point = new Point();
        if (orientation.isHorizontal()) {
            point.y = jComponent.getHeight();
        } else {
            point.x = jComponent.getWidth();
        }
        SwingUtilities.convertPointToScreen(point, jComponent);
        DialogWindow dialogWindow = new DialogWindow(jComponent, this);
        dialogWindow.setUndecorated(true);
        dialogWindow.setContent(this.getContent());
        dialogWindow.open(point.x, point.y);
        this.openPopup(dialogWindow);
    }

    protected void onMenuItemTrigger(Dockable dockable) {
        if (this.content == null) {
            return;
        }
        this.closePopup();
        DialogWindow dialogWindow = new DialogWindow(dockable.getComponent(), this);
        dialogWindow.setUndecorated(this.getMenuBehavior() == MenuBehavior.UNDECORATED_DIALOG);
        dialogWindow.setContent(this.getContent());
        dialogWindow.open(dockable.getComponent());
        this.openPopup(dialogWindow);
    }

    protected void onMenuTrigger(JPopupMenu jPopupMenu) {
        if (this.content == null) {
            return;
        }
        jPopupMenu.add(this.content);
        MenuWindow menuWindow = new MenuWindow(jPopupMenu);
        this.openPopup(menuWindow);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PanelPopup
    extends SimpleDockAction {
        @Override
        public <V> V createView(ViewTarget<V> viewTarget, ActionViewConverter actionViewConverter, Dockable dockable) {
            return actionViewConverter.createView(PANEL_POPUP, this, viewTarget, dockable);
        }

        @Override
        public boolean trigger(Dockable dockable) {
            return false;
        }

        public CPanelPopup getAction() {
            return CPanelPopup.this;
        }

        public void onMousePressed(JComponent jComponent, DockTitle.Orientation orientation) {
            CPanelPopup.this.onMousePressed(jComponent, orientation);
        }

        public void onMouseReleased(JComponent jComponent, DockTitle.Orientation orientation) {
            CPanelPopup.this.onMouseReleased(jComponent, orientation);
        }

        public void onTrigger(JComponent jComponent, DockTitle.Orientation orientation) {
            CPanelPopup.this.onTrigger(jComponent, orientation);
        }

        public void onMenuItemTrigger(Dockable dockable) {
            CPanelPopup.this.onMenuItemTrigger(dockable);
        }

        public void onMenuTrigger(JPopupMenu jPopupMenu) {
            CPanelPopup.this.onMenuTrigger(jPopupMenu);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ButtonBehavior {
        OPEN_ON_PRESS,
        OPEN_ON_CLICK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MenuBehavior {
        HIDE,
        SUBMENU,
        UNDECORATED_DIALOG,
        DECORATED_DIALOG;

    }
}

