/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.ChangeableColorHighlightPainter;

class MarkOccurrencesHighlightPainter
extends ChangeableColorHighlightPainter {
    private Color borderColor;

    public MarkOccurrencesHighlightPainter() {
        super(Color.BLUE);
    }

    public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        graphics.setColor(this.getColor());
        if (n == ++n2) {
            try {
                Shape shape2 = view.modelToView(n, shape, Position.Bias.Forward);
                Rectangle rectangle = shape2.getBounds();
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                return rectangle;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return null;
            }
        }
        if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return rectangle;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        try {
            Shape shape3 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
            Rectangle rectangle = shape3 instanceof Rectangle ? (Rectangle)shape3 : shape3.getBounds();
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setColor(this.borderColor);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            return rectangle;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    public void setColor(Color color) {
        super.setColor(color);
        this.borderColor = color.darker();
    }
}

