% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_spectra.R
\name{apply_by_band}
\alias{apply_by_band}
\alias{apply_by_band.spectra}
\title{Apply numeric function by band}
\usage{
apply_by_band(x, fun, na.rm = TRUE, keep_txt_meta = TRUE, name = NULL, ...)

\method{apply_by_band}{spectra}(x, fun, na.rm = TRUE, keep_txt_meta = TRUE, name = NULL, ...)
}
\arguments{
\item{x}{spectra}

\item{fun}{numeric function to be applied to each band.}

\item{na.rm}{boolean. remove NAs?}

\item{keep_txt_meta}{boolean. try to keep text in the metadata?}

\item{name}{name for each sample in the output spectra. The default (NULL) will
give samples sequential numeric names. Recycled if necessary.}

\item{...}{extra arguments passed to fun}
}
\value{
spectra
}
\description{
\code{apply_by_band} is conceptually similar to apply(as.matrix(x), 2, fun),
but returns a spectra object while dealing with metadata and attributes.
Applying a function that does not act on numeric values may crash the function
or render all value values NA.
}
\section{Methods (by class)}{
\itemize{
\item \code{spectra}: Apply a numeric function by band
}}

\examples{
library(spectrolab)
spec = as.spectra(spec_matrix_example, name_idx = 1)
spec_mean = apply_by_band(spec, mean)
}
\author{
Jose Eduardo Meireles

Jose Eduardo Meireles
}
