% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_function_overloads.R
\name{quantile.spectra}
\alias{quantile.spectra}
\title{Compute spectra quantiles}
\usage{
\method{quantile}{spectra}(x, probs = c(0.025, 0.25, 0.5, 0.75, 0.975),
  na.rm = TRUE, names = NULL, ...)
}
\arguments{
\item{x}{spectra object. Must have at least the same number of sample that
length(probs) has.}

\item{probs}{Probabilities to compute quantiles. Must be a vector of numerics
between 0.0 and 1.0. Defaults to c(0.025, 0.25, 0.5, 0.75, 0.975).}

\item{na.rm}{remove NAs before computing quantiles? Defaults to TRUE}

\item{names}{names for each quantile spectrum. If NULL (default), names are set
to probs. A char vector should otherwise be given. Recyled.}

\item{...}{other arguments passed to quantile.}
}
\value{
spectra object with one spectrum for each prob
}
\description{
\code{quantile} computes quantiles by wavelength and returns them as `spectra`
}
\examples{
library(spectrolab)
spec = as.spectra(spec_matrix_example, name_idx = 1)
quantile(spec, probs = c(0.25, 0.75))
}
\author{
Jose Eduardo Meireles
}
