% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinatorialGraphLaplacian.R
\name{learn_combinatorial_graph_laplacian}
\alias{learn_combinatorial_graph_laplacian}
\title{Learn the Combinatorial Graph Laplacian from data

Learns a graph Laplacian matrix using the Combinatorial Graph Laplacian (CGL)
algorithm proposed by Egilmez et. al. (2017)}
\usage{
learn_combinatorial_graph_laplacian(
  S,
  A_mask = NULL,
  alpha = 0,
  reltol = 1e-05,
  max_cycle = 10000,
  regtype = 1,
  record_objective = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{S}{sample covariance matrix}

\item{A_mask}{binary adjacency matrix of the graph}

\item{alpha}{L1-norm regularization hyperparameter}

\item{reltol}{minimum relative error considered for the stopping criteri}

\item{max_cycle}{maximum number of cycles}

\item{regtype}{type of L1-norm regularization. If reg_type == 1, then all
elements of the Laplacian matrix will be regularized. If reg_type == 2,
only the off-diagonal elements will be regularized}

\item{record_objective}{whether or not to record the objective function value
at every iteration. Default is FALSE}

\item{verbose}{if TRUE, then a progress bar will be displayed in the console. Default is TRUE}
}
\value{
A list containing possibly the following elements
\item{\code{laplacian}}{estimated Laplacian Matrix}
\item{\code{elapsed_time}}{elapsed time recorded at every iteration}
\item{\code{frod_norm}}{relative Frobenius norm between consecutive estimates of the Laplacian matrix}
\item{\code{convergence}}{whether or not the algorithm has converged within the tolerance and max number of iterations}
\item{\code{obj_fun}}{objective function value at every iteration, in case record_objective = TRUE}
}
\description{
Learn the Combinatorial Graph Laplacian from data

Learns a graph Laplacian matrix using the Combinatorial Graph Laplacian (CGL)
algorithm proposed by Egilmez et. al. (2017)
}
\references{
H. E. Egilmez, E. Pavez and A. Ortega, "Graph Learning From Data
            Under Laplacian and Structural Constraints", in IEEE Journal of
            Selected Topics in Signal Processing, vol. 11, no. 6, pp. 825-841, Sept. 2017.
            Original MATLAB source code is available at: https://github.com/STAC-USC/Graph_Learning
}
