% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thermalrange.R
\name{thermal_ranges}
\alias{thermal_ranges}
\title{Collates minimum, maximum, and preferable temperatures from FishBase.}
\usage{
thermal_ranges(
  x,
  colsp = NULL,
  verbose = FALSE,
  pct = 90,
  sn = FALSE,
  synonym = fishbase(tables = "synonym"),
  ranges = fishbase(tables = "ranges")
)
}
\arguments{
\item{x}{\code{dataframe} or \code{string}. species names or a dataframe of species to aid in retrieving temperature ranges from FishBase.}

\item{colsp}{\code{string}. if \strong{\code{x}} is a data frame, then the column species is required. Otherwise for list of species or vector, the \code{colsp} is NULL.}

\item{verbose}{\code{logical} To return implementation messages. Default \code{FALSE}.}

\item{pct}{\code{numeric}. Provide the perecentage similarity of the species name provided and the one in FishBase. The lower the \code{pct} value, the higher the chances
of getting a wrong species in the standard databases (FishBase). The plausible pct value should be greater than \strong{0.9}.}

\item{sn}{\code{logical}. Either to output synonym or only accepted names. This parameter reduces duplication of species synonyms and old name etc. For more information
see \href{https://www.fishbase.se/}{FishBase}.}

\item{synonym}{\code{fishbasedataframe}. A standard database for species synonym names from FishBase. See \href{https://www.fishbase.se/}{FishBase} for more information.}

\item{ranges}{\code{fishbasedataframe}. A standard database for ecological ranges from FishBase. See \href{https://www.fishbase.se/}{FishBase} for more information.}
}
\value{
Data table for minimum, maximum and preferable species temperatures from FishBase.
}
\description{
Collates minimum, maximum, and preferable temperatures from FishBase.
}
\examples{

\dontrun{

x <- thermal_ranges(x = "Salmo trutta")
}

}
