% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotControlDistributions}
\alias{plotControlDistributions}
\title{Plots control variable distributions.}
\usage{
plotControlDistributions(sca_data, title = "", type = "density")
}
\arguments{
\item{sca_data}{A data frame returned by `sca()` containing model estimates
from the specification curve analysis.}

\item{title}{A string to use as the plot title. Defaults to an empty string,
`""`.}

\item{type}{A string indicating what type of distribution plot to produce.
When `type = "density"` density plots are produced. When
`type = "hist"` or `type = "histogram"` histograms are produced.
Defaults to `"density"`.}
}
\value{
A ggplot object.
}
\description{
plotControlDistributions() plots the distribution of coefficients for each
control variable included in the model specifications.
}
\examples{
plotControlDistributions(sca_data = sca(y="Salnty", x="T_degC",
                                    controls = c("ChlorA", "O2Sat"),
                                    data = bottles,
                                    progressBar = TRUE, parallel = FALSE),
                         title = "Control Variable Distributions")
plotControlDistributions(sca_data = sca(y = "Salnty", x="T_degC",
                                    controls = c("ChlorA*O2Sat"),
                                    data = bottles,
                                    progressBar = FALSE, parallel = FALSE),
                         type = "hist")
plotControlDistributions(sca_data = sca(y = "Salnty", x = "T_degC",
                                    controls = c("ChlorA*NO3uM",
                                                 "O2Sat*NO3uM"),
                                    data = bottles, progressBar = TRUE,
                                    parallel = TRUE, workers = 2),
                         type = "density")
}
