\name{dohClusterCustommedSegments}
\alias{dohClusterCustommedSegments}
 
\title{
Use CluPA for alignment with additional information
}
\description{
This function integrates some additional information from user such as references for each specific segment, segment ignorance, maximum step size..
to align spectra using CluPA. 

}
\usage{
dohClusterCustommedSegments(X,
                            peakList,
                            refInd,
                            segmentInfoMat,
                            minSegSize = 128,
                            maxShift = 100,
                            acceptLostPeak = TRUE,                            
                            verbose=TRUE)
}
 
\arguments{
  \item{X}{
The spectral dataset in matrix format in which each row contains a single sample.
}
  \item{peakList}{
The peak lists of the spectra.
}
  \item{refInd}{
The index of the reference spectrum.
}
  \item{segmentInfoMat}{
The matrix containing the additional information for segments from the users. This parameter must be a matrix.
}
  \item{minSegSize}{
The minimum size of the segments which could be considered for alignment.
}
  \item{maxShift}{
The maximum number of points for a shift step.
}
  \item{acceptLostPeak}{
This is an option for users, TRUE is the default value. If the users believe that all the peaks in the peak list are true positive, change it to FALSE.
}
  \item{verbose}{
A boolean value to allow print out process information.
}
}
\details{
Each row of the segmentInfoMat matrix includes 5 values. For example, it could be imported from a CSV file consisting of following content:

#

begin,end,forAlign,ref,maxShift

100,200,0,0,0

450,680,1,0,50

#

Each column could be explained as the following:

- begin: the starting point of the segment.

- end: the end point of the segment.

- forAlign: the segment is aligned (1) or not (0).

- ref: the index of the reference spectrum. If 0, the algorithm will select the reference found by the reference finding step.

- maxShift: the maximum number of points of a shift to left/right.

It is worth to note that only segments with forAlign=1 (column 3) will be taken into account for spectral alignment. 
}
\value{
 
The aligned spectral segments.
}

\author{
Trung Nghia Vu 
}

\seealso{
\code{\link{dohCluster}}  
}
\examples{ cat("\n Please see more examples in the vignettes file.")

res=makeSimulatedData();
X=res$data;
groupLabel=res$label;



peakList <- detectSpecPeaks(X,
  nDivRange = c(128),                
  scales = seq(1, 16, 2),
  baselineThresh = 50000,
  SNR.Th = -1,
    verbose=FALSE
);


resFindRef<- findRef(peakList);
refInd <- resFindRef$refInd;


segmentInfoMat=matrix(data=c(100,200,0,0,0,
                      50,680,1,0,50),nrow=2,ncol=5,byrow=TRUE
                      )
colnames(segmentInfoMat)=c("begin","end","forAlign","ref","maxShift")
segmentInfoMat

maxShift = 50;
Yc <- dohClusterCustommedSegments(X,
                                 peakList = peakList,
                                 refInd = refInd,
                                 maxShift  = maxShift,
                                 acceptLostPeak = TRUE,
                                 segmentInfoMat = segmentInfoMat,
                                 minSegSize = 128,
                                 verbose=FALSE)
}
 
 
\keyword{ segment }
\keyword{ CluPA }
\keyword{ alignment } 
