% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{cluster}
\alias{cluster}
\title{SpeakEasy 2 community detection}
\usage{
cluster(
  graph,
  discard_transient = 3,
  independent_runs = 10,
  max_threads = 0,
  seed = 0,
  target_clusters = 0,
  target_partitions = 5,
  subcluster = 1,
  min_clust = 5,
  verbose = FALSE,
  is_directed = "detect"
)
}
\arguments{
\item{graph}{A graph or adjacency matrix in a form that can be converted to
\code{matrix} or \code{Matrix::dgCMatrix} using an \code{as.matrix()} coercion method.
Accepted types include \code{matrix}, \code{dgCMatrix}, \code{ngCMatrix}, and
\code{igraph::graph}s.}

\item{discard_transient}{The number of partitions to discard before tracking.}

\item{independent_runs}{How many runs SpeakEasy2 should perform.}

\item{max_threads}{The maximum number of threads to use. By default this is
the same as the number of independent runs. If max_threads is greater than
or equal to the number of processing cores, all cores may run. If
max_threads is less than the number of cores, at most max_threads cores
will run.}

\item{seed}{Random seed to use for reproducible results. SpeakEasy2 uses a
different random number generator than R, but if the seed is not
explicitly set, R's random number generator is used create one. Because of
this, setting R's RNG will also cause reproducible results.}

\item{target_clusters}{The number of random initial labels to use.}

\item{target_partitions}{Number of partitions to find per independent run.}

\item{subcluster}{Depth of clustering. If greater than 1, perform recursive
clustering.}

\item{min_clust}{Smallest clusters to recursively cluster. If subcluster not
set to a value greater than 1, this has no effect.}

\item{verbose}{Whether to provide additional information about the
clustering or not.}

\item{is_directed}{Whether the graph should be treated as directed or not.
By default, if the graph is symmetric it is treated as undirected.}
}
\value{
A membership vector. If subclustering, returns a matrix with number
of rows equal to the number of recursive clustering. Each row is the
membership at different hierarchical scales, such that the last rows are
the highest resolution.
}
\description{
Group nodes into communities.
}
\examples{
if (require("igraph")) {
  graph <- igraph::graph.famous("zachary")
  membership <- cluster(graph, max_threads = 2)
}
}
