% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print_iteration_information}
\alias{print_iteration_information}
\title{Prints iteration information}
\usage{
print_iteration_information(
  iter,
  values,
  criteria,
  digits = 4,
  padding = 10,
  width = 80,
  efficiency_criteria
)
}
\arguments{
\item{iter}{An integer giving the iteration of the loop}

\item{values}{The value of the efficiency criteria obtained by
\code{\link{calculate_efficiency_criteria}}}

\item{criteria}{A character string with the name of the efficiency criteria.
See manual for valid values}

\item{digits}{The nubmer of digits to round the printed value to. The default
is 4.}

\item{padding}{An integer specifying the padding of each column element.
Default value is 10.}

\item{width}{An integer giving the width of the horizontal rules. Default
value is 80}

\item{efficiency_criteria}{The criteria that we optimize over}
}
\value{
Nothing
}
\description{
Prints iteration information every time a better design is found. The
function wraps around \code{\link{print_initial_header}} and
\code{\link{print_efficiency_criteria}}. This reduces the number of
if-statements and function calls within \code{\link{generate_design}} in an
attempt simplify code maintenance.
}
