% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SPCA_Corr_And_Uncor_Funcs.R
\name{spca}
\alias{spca}
\title{Computes sparse principal components solutions}
\usage{
spca(S, ind, unc = TRUE)
}
\arguments{
\item{S}{A correlation or covariance matrix.}

\item{ind}{A list of indices for each dimension. The number of dimensions to
compute is determined by its length. If only the first dimension is
required, it can be a vector.}

\item{unc}{A logical vector indicating which components should be should be
computed uncorrelated to the preceeding ones. Can be shorter than the number
of dimensions to compute. See details.}
}
\value{
An object of class \emph{spca} is returned. It is the smallest
instance of an spca object, which contains: \item{loadings}{The matrix of
loadings} \item{contributions}{Matrix of loadings scaled to unit \eqn{L_1}
norm.} \item{vexpv}{a vector of variances explained by each component}
\item{vexp}{a vector of variances explained by each PC} In addition, if
\code{any unc[j] = FALSE}: \item{corComp}{The matrix with correlations among
components.} \item{loadingsUnc}{Loadings of the components made
uncorrelated.}
}
\description{
Computes LS SPCA sparse principal components loadings for a given set of
indices.\cr See the package vignettes for details.
}
\details{
The number of components to compute is determind from the length of
\emph{ind}.  If \emph{unc} has fewer elements than the number of indices
passed, the remaining elements are set equal to the last one.
}
\examples{
\dontrun{
	 data(anthrop, package = "spca")
	 # for uncorrelated components
	 myspca <- spca(anthrop, ind = list(1:2, 3:7))
	 ## print loadings
	 myspca
	 ## print summaries
	 summary(myspca)
	 # for correlated components
	 myspcac <- spca(anthrop, ind = list(1:2, 3:7), unc = FALSE)
	 myspcac
	 summary(myspcac)
	 ## print correlation between components
	 myspcac$corComp
	 ## print loadings of components made uncorrelated
	 myspcac$loadingsUnc
	 ## compare the two results numerically and graphically
	compare(myspca, myspcac, methodsnames = c("Unc", "Cor"), shortnamescomp = FALSE)
   }
}
\seealso{
\code{\link{spcabb}}, \code{\link{spcabe}}, \code{\link{summary.spca}}
}
\keyword{LS}
\keyword{SPCA}

