\name{survspat}
\alias{survspat}
\title{survspat function}
\usage{
survspat(formula, data, dist, cov.model, mcmc.control, priors,
  control = inference.control(gridded = FALSE))
}
\arguments{
  \item{formula}{the model formula in a format compatible
  with the function flexsurvreg from the flexsurv package}

  \item{data}{a SpatialPointsDataFrame object containing
  the survival data as one of the columns}

  \item{dist}{choice of distribution function for baseline
  hazard. Current options are: exponentialHaz, weibullHaz,
  gompertzHaz, makehamHaz, tpowHaz}

  \item{cov.model}{an object of class covmodel, see
  ?covmodel ?ExponentialCovFct or ?SpikedExponentialCovFct}

  \item{mcmc.control}{mcmc control parameters, see
  ?mcmcpars}

  \item{priors}{an object of class Priors, see ?mcmcPriors}

  \item{control}{additional control parameters, see
  ?inference.control}
}
\value{
an object inheriting class 'mcmcspatsurv' for which there
exist methods for printing, summarising and making
inference from.
}
\description{
A function to run a Bayesian analysis on censored spatial
survial data assuming a proportional hazards model using an
adaptive Metropolis-adjusted Langevin algorithm.
}
\seealso{
\link{tpowHaz}, \link{exponentialHaz}, \link{gompertzHaz},
\link{makehamHaz}, \link{weibullHaz}, \link{covmodel},
link{ExponentialCovFct}, \code{SpikedExponentialCovFct},
\link{mcmcpars}, \link{mcmcPriors},
\link{inference.control}
}

