\name{heather}
\alias{heather}
\docType{data}
\title{Diggle's Heather Data}
\description{
  The spatial mosaic of vegetation of the heather plant
  (\emph{Calluna vulgaris}) recorded in a 10 by 20 metre
  sampling plot in Sweden.
} 
\format{
  A list with three entries, representing the same data at
  different spatial resolutions:
  \tabular{ll}{
    \code{coarse} \tab original heather data, 100 by 200 pixels \cr
    \code{medium} \tab current  heather data, 256 by 512 pixels \cr
    \code{fine} \tab   finest resolution data, 778 by 1570 pixels
  }
  Each of these entries is an object of class \code{"owin"}
  containing a binary pixel mask. 
}
\usage{data(heather)}
\source{Peter Diggle}
\section{Notes on data}{
  These data record the spatial mosaic of vegetation
  of the heather plant (\emph{Calluna vulgaris}) in a 10 by 20 metre
  sampling plot near \ifelse{latex}{\out{J{\"a}dra{\aa}s}}{Jadraas}, Sweden. 
  They were recorded and first analysed by Diggle(1981).

  The dataset \code{heather} contains three different versions of the data
  that have been analysed by different writers over the decades.

  \describe{
    \item{coarse:}{
      Data as originally digitised by Diggle in 1983
      at 100 by 200 pixels resolution (i.e. 10 pixels = 1 metre).

      These data were entered by hand in the form of a
      run-length encoding (original file no longer available)
      and translated by a program into a 100 by 200 pixel binary image.

      There are known to be some errors in the image
      which arise from errors in counting the run-length
      so that occasionally there will be an unexpected 'spike'
      on one single column.
    }
    \item{fine:}{
      A fine scale digitisation of the original map,
      prepared by CWI (Centre for Computer Science, Amsterdam,
      Netherlands) in 1994.

      The original hand-drawn map
      was scanned by Adrian Baddeley, and processed
      by Chris Jonker, Henk Heijmans and Adrian Baddeley
      to yield a clean binary image of 778 by 1570 pixels resolution.
    }
    \item{medium:}{
      The version of the heather data currently supplied on
      Professor Diggle's website. This is a 256 by 512 pixel image.
      The method used to create this image is not stated.
    }
  }
}
\section{History of analysis of data}{
  The data were recorded, presented and analysed by Diggle (1983).
  He proposed a Boolean model consisting of discs of random size
  with centres generated by of a Poisson point process.
  
  Renshaw and Ford (1983) reported that spectral analysis of the data
  suggested the presence of strong row and column effects. However, this
  may have been attributable to errors in the run-length encoding
  of the original data.

  Hall (1985) and Hall (1988, pp 301-318) took a bootstrap approach.

  Ripley (1988, pp. 121-122, 131-135] used opening and closing functions
  to argue that a Boolean model of discs is inappropriate.

  Cressie (1991, pp. 763-770) tried a more general Boolean model.
}
\references{
  Cressie, N.A.C. (1991)
  \emph{Statistics for Spatial Data}.
  John Wiley and Sons, New York.

  Diggle, P.J. (1981)
  Binary mosaics and the spatial pattern of heather.
  \emph{Biometrics} \bold{37}, 531-539.

  Hall, P. (1985)
  Resampling a coverage pattern.
  \emph{Stochastic Processes and their Applications}
  \bold{20} 231-246.

  Hall, P. (1988)
  \emph{An introduction to the theory of coverage processes}.
  John Wiley and Sons, New York.

  Renshaw, E. and Ford, E.D. (1983)
  The interpretation of process from pattern using
  two-dimensional spectral analysis: Methods and
  problems of interpretation. \emph{Applied Statistics} \bold{32} 51-63.
  
  Ripley, B.D. (1988)
  \emph{Statistical Inference for Spatial Processes}.
  Cambridge University Press.
} 
\keyword{datasets}
\keyword{spatial}

