% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{convert_crs_df}
\alias{convert_crs_df}
\title{Convert Coordinate Reference System (CRS)}
\usage{
convert_crs_df(
  df,
  crs_from = 3035,
  crs_to = 4326,
  lon_from = "x",
  lat_from = "y",
  lon_to = "lon",
  lat_to = "lat"
)
}
\arguments{
\item{df}{data.frame to be converted.}

\item{crs_from}{CRS code of the original coordinate system (default: 3035).}

\item{crs_to}{CRS code of the target coordinate system (default: 4326).}

\item{lon_from}{column name of longitude values in \code{df} (default: "x").}

\item{lat_from}{column name of latitude values in \code{df} (default: "y").}

\item{lon_to}{column name for longitude values in the converted data frame
(default: "lon").}

\item{lat_to}{column name for latitude values in the converted data frame
(default: "lat").}
}
\value{
data.frame with converted coordinates
}
\description{
Convert Coordinate Reference System (CRS) of a data.frame
from one CRS to another.
}
\author{
Martin Haringa
}
