% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_ggplot2.R
\name{choropleth_ggplot2}
\alias{choropleth_ggplot2}
\title{Map object of class sf using ggplot2}
\usage{
choropleth_ggplot2(
  sf_object,
  value = output,
  n = 7,
  dig.lab = 2,
  legend_title = "Class",
  option = "D",
  direction = 1
)
}
\arguments{
\item{sf_object}{object of class sf}

\item{value}{column to shade the polygons}

\item{n}{number of clusters (default is 7)}

\item{dig.lab}{number of digits in legend (default is 2)}

\item{legend_title}{title of legend}

\item{option}{a character string indicating the colormap option to use. Four options are available: "magma" (or "A"), "inferno" (or "B"), "plasma" (or "C"), "viridis" (or "D", the default option) and "cividis" (or "E").}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors are ordered from darkest to lightest. If -1, the order of colors is reversed.}
}
\value{
ggplot map
}
\description{
Takes an object produced by \code{choropleth_sf()}, and creates the correspoding choropleth map.
}
\examples{
test <- points_to_polygon(nl_postcode2, insurance, sum(amount, na.rm = TRUE))
choropleth_ggplot2(test)
}
\author{
Martin Haringa
}
