% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral.separability.R
\name{spectral.separability}
\alias{spectral.separability}
\title{spectral separability}
\usage{
spectral.separability(x, y, jeffries.matusita = TRUE)
}
\arguments{
\item{x}{data.frame, matrix or vector of spectral values must,
match classes defined in y}

\item{y}{A vector or factor with grouping classes, must match
row wise values in x}

\item{jeffries.matusita}{(TRUE/FALSE) Return J-M distance (default) else Bhattacharyya}
}
\value{
A matrix of class-wise Jeffries-Matusita or Bhattacharyya distance separability values
}
\description{
Calculates spectral separability by class
}
\details{
Available statistics:
\itemize{
\item Bhattacharyya distance (Bhattacharyya 1943; Harold 2003) measures the similarity
of two discrete or continuous probability distributions.
\item Jeffries-Matusita (default) distance (Bruzzone et al., 2005; Swain et al., 1971)
is a scaled (0-2) version of Bhattacharyya. The J-M distance is asymptotic to 2,
where 2 suggest complete separability.
}
}
\examples{
require(MASS)                
# Create example data 
d <- 6                 # Number of bands
n.class <- 5           # Number of classes
n <- rep(1000, 5)                
mu <- round(matrix(rnorm(d*n.class, 128, 1), 
            ncol=n.class, byrow=TRUE), 0)

x <- matrix(double(), ncol=d, nrow=0)
  classes <- integer()
    for (i in 1:n.class) {
      f <- svd(matrix(rnorm(d^2), ncol=d))
      sigma <- t(f$v) \%*\% diag(rep(10, d)) \%*\% f$v
      x <- rbind(x, mvrnorm(n[i], mu[, i], sigma))
      classes <- c(classes, rep(i, n[i]))
    }
colnames(x) <- paste0("band", 1:6)
classes <- factor(classes, labels=c("water", "forest",
                  "shrub", "urban", "ag"))

# Separability for multi-band (multivariate) spectra 
spectral.separability(x, classes)

# Separability for single-band (univariate) spectra 
spectral.separability(x[,1], classes)

}
\references{
Bhattacharyya, A. (1943) On a measure of divergence between two statistical
populations defined by their probability distributions'. Bulletin of the
Calcutta Mathematical Society 35:99-109

Bruzzone, L., F. Roli, S.B. Serpico (1995) An extension to multiclass cases of
the Jefferys-Matusita distance. IEEE Transactions on Pattern Analysis and
Machine Intelligence 33:1318-1321

Kailath, T., (1967) The Divergence and Bhattacharyya measures in signal
selection. IEEE Transactions on Communication Theory 15:52-60
}
\author{
Jeffrey S. Evans  \href{mailto:jeffrey_evans@tnc.org}{jeffrey_evans@tnc.org}
}
