% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runFunctions.R
\name{spathialPlot}
\alias{spathialPlot}
\title{2D spathial}
\usage{
spathialPlot(
  X,
  X_labels,
  boundary_ids,
  spathial_res,
  perplexity_value = NULL,
  mask = NULL,
  title = NULL,
  ...
)
}
\arguments{
\item{X}{data points}

\item{X_labels}{labels of the data points}

\item{boundary_ids}{waypoints}

\item{spathial_res}{principal path from the starting point to the ending point}

\item{perplexity_value}{the value for TSNE perplexity (default is nrsamples*3/50)}

\item{mask}{the mask of the sample to preserve (when prefiltering is computed)}

\item{title}{the title of the plot}

\item{...}{Parameters which will be inherited by plot()}
}
\description{
Get the 2D coordinates of each waypoint (using t-SNE algorithm for the dimensionality reduction)
}
\examples{
load(system.file('extdata','X.rda',package='spathial',mustWork=TRUE))
# Load description vector X_labels
load(system.file('extdata','X_labels.rda',package='spathial',mustWork=TRUE))
# Run spathialBoundary
boundaryRes <- spathialBoundaryIds(X, X_labels, mode=2, from=3, to=6)
X <- boundaryRes$X
X_labels <- boundaryRes$X_labels
boundary_ids <- boundaryRes$boundary_ids
#Set the number of waypoints
NC <- 20
# Run spathialWay
spathial_res <- spathialWay(X, boundary_ids, NC)
#Run spathialPlot with spathial_res
spathialPlot(X, X_labels, boundary_ids, spathial_res, perplexity_value=30)
}
