% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runFunctions.R
\name{spathialBoundaryIds}
\alias{spathialBoundaryIds}
\title{Select starting and ending points}
\usage{
spathialBoundaryIds(X, X_labels = NULL, mode = 1, from = NULL, to = NULL)
}
\arguments{
\item{X}{data points}

\item{X_labels}{labels of the data points}

\item{mode}{strategy for boundary selection
\itemize{
  \item 1 - selected by the user
  \item 2 - centroids
  \item 3 - insert the row name of the starting and ending points
}}

\item{from}{starting class or row name of the starting point}

\item{to}{ending class or row name of the ending point}
}
\value{
A list of objects
\itemize{
  \item boundary ids: the indexes of the boundaries
  \item X: the new data matrix with the boundary
  \item X_labels: the new labels of the data matrix with the boundary labels
}
}
\description{
Get the coordinates of the starting and ending points
}
\examples{
# Load data matrix X
load(system.file('extdata','X.rda',package='spathial',mustWork=TRUE))
# Load description vector X_labels
load(system.file('extdata','X_labels.rda',package='spathial',mustWork=TRUE))
# Run spathialBoundary
boundaryRes <- spathialBoundaryIds(X, X_labels, mode=2, from=3, to=6)
}
