% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SARARgamlss.R
\name{SARARgamlss}
\alias{SARARgamlss}
\title{SARARgamlss: Spatial Autoregressive Generalized Additive Model for Location Scale (GAMLSS)}
\usage{
SARARgamlss(
  formula,
  sigma.formula = ~1,
  W1 = diag(0, nrow(data)),
  W2 = diag(0, nrow(data)),
  data,
  tol = 1e-04,
  maxiter = 20,
  type = c("SAR", "SARAR", "SEM"),
  weights = NULL
)
}
\arguments{
\item{formula}{A formula specifying the mean structure of the model (response ~ explanatory variables).}

\item{sigma.formula}{A formula specifying the variance structure of the model (default: ~1).}

\item{W1}{A spatial weights matrix for the SAR term (default: identity matrix).}

\item{W2}{A spatial weights matrix for the SARAR term (default: identity matrix).}

\item{data}{A data.frame containing the variables used in the model.}

\item{tol}{Convergence tolerance (default: 1E-4).}

\item{maxiter}{Maximum number of iterations for optimization (default: 20).}

\item{type}{The type of spatial model to fit: one of "SAR", "SARAR", or "SEM".}

\item{weights}{Optional weights for the observations (default: NULL).}
}
\value{
A fitted GAMLSS model object with spatial autoregressive terms. The model object also includes
the variance of the spatial parameters \eqn{\hat{\rho}} and \eqn{\hat{\lambda}}
}
\description{
This function estimates a Spatial Autoregressive Generalized Additive Model for Location Scale 
(SARARgamlss) using GAMLSS. The model includes both spatial dependencies and the possibility of 
non-parametric terms in the formulas for the mean and variance. The function supports SAR, SARAR, 
and SEM model types and performs the estimation through an iterative process that updates spatial 
dependence parameters. The variance of the spatial parameters \eqn{\hat{\rho}} and \eqn{\hat{\lambda}}
is estimated using the inverse of the Hessian matrix from the optimization.
}
\examples{
library(spdep)
library(gamlss)
data(oldcol)
# Create spatial weight matrices W1 and W2
W1 <- spdep::nb2mat(COL.nb, style = "W")
W2 <- W1  # In this case, assume the same spatial weights for both
# Fit a SARARgamlss model
result <- SARARgamlss(formula = CRIME ~ INC + cs(HOVAL), 
sigma.formula = ~ INC + pb(HOVAL), W1 = W1, W2 = W2,data = COL.OLD, 
tol = 1E-4,  maxiter = 20, type = "SARAR")
summary_SAR(result)
gamlss::term.plot(result$gamlss, what="mu")

}
\references{
Toloza-Delgado, J. D., Melo, O. O., & Cruz, N. A.
 Joint spatial modeling of mean and non-homogeneous variance combining semiparametric SAR 
 and GAMLSS models for hedonic prices. Spatial Statistics, 65, 100864 (2025)
 @source https://doi.org/10.1016/j.spasta.2024.100864
}
