% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measles.R
\name{measles}
\alias{measles}
\title{Measles in UK spatPomp generator}
\usage{
measles(
  U = 6,
  dt = 2/365,
  fixed_ivps = TRUE,
  S_0 = 0.032,
  E_0 = 5e-05,
  I_0 = 4e-05
)
}
\arguments{
\item{U}{A length-one numeric signifying the number of cities to be represented in the spatPomp object.}

\item{dt}{a numeric (in unit of years) that is used as the Euler time-increment for simulating measles data.}

\item{fixed_ivps}{a logical. If \code{TRUE} initial value parameters will be
declared in the \code{globals} slot, shared for each unit, and
will not be part of the parameter vector.}

\item{S_0}{a numeric. If \code{fixed_ivps=TRUE} this is the initial proportion of all of the spatial units that are susceptible.}

\item{E_0}{a numeric. If \code{fixed_ivps=TRUE} this is the initial proportion of all of the spatial units that are exposed.}

\item{I_0}{a numeric. If \code{fixed_ivps=TRUE} this is the initial proportion of all of the spatial units that are infected.}
}
\value{
An object of class \sQuote{spatPomp} representing a \code{U}-dimensional spatially coupled measles POMP model.
}
\description{
Generate a spatPomp object for measles in the top-\code{U} most populous cities in England and Wales.
The model is adapted from He et al. (2010) with gravity transport following Park and Ionides (2019).
The data are from Dalziel et al (2016).
}
\note{
This function goes through a typical workflow of constructing
a typical spatPomp object (1-4 below). This allows the user to have a
file that replicates the exercise of model building as well as function
that creates a typical nonlinear model in epidemiology in case they want
to test a new inference methodology. We purposely do not modularize this
function because it is not an operational piece of the package and is
instead useful as an example.\cr
1. Getting a measurements data.frame with columns for times,
   spatial units and measurements.\cr
2. Getting a covariates data.frame with columns for times,
   spatial units and covariate data.\cr
3. Constructing model components (latent state initializer,
   latent state transition simulator and measurement model). Depending
   on the methods used, the user may have to supply a vectorfield to
   be integrated that represents the deterministic skeleton of the latent
   process.\cr
4. Bringing all the data and model components together to form a
   spatPomp object via a call to spatPomp().
}
\examples{
# Complete examples are provided in the package tests
\dontrun{
m <- measles(U = 5)
# See all the model specifications of the object
spy(m)
}
}
\references{
\ionides2021

\dalziel2016
}
\seealso{
Other spatPomp examples: 
\code{\link{bm}()},
\code{\link{he10}()},
\code{\link{lorenz}()}
}
\author{
Edward L. Ionides
}
\concept{spatPomp examples}
