% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iubf.R
\name{iubf}
\alias{iubf}
\alias{iubf-spatPomp}
\alias{iubf,spatPomp-method}
\title{Iterated Unadapted Bagged Filter (IUBF)}
\usage{
\S4method{iubf}{spatPomp}(
  object,
  Nubf = 1,
  Nrep_per_param,
  Nparam,
  nbhd,
  prop,
  rw.sd,
  cooling.type = c("geometric", "hyperbolic"),
  cooling.fraction.50,
  tol = (1e-18)^17,
  verbose = getOption("verbose"),
  ...
)
}
\arguments{
\item{object}{A \code{spatPomp} object.}

\item{Nubf}{The number of iterations to perform}

\item{Nrep_per_param}{The number of replicates used to estimate the likelihood at a parameter}

\item{Nparam}{The number of parameters that will undergo the iterated perturbation}

\item{nbhd}{A neighborhood function with three arguments: \code{object}, \code{time} and \code{unit}.
The function should return a \code{list} of two-element vectors that represent space-time neighbors of \eqn{(u,n)},
which is represented by \code{c(unit,time)}. See example below for more details.}

\item{prop}{A numeric between 0 and 1. The top \code{prop}*100\% of the parameters are resampled at each observation}

\item{rw.sd}{specification of the magnitude of the random-walk perturbations that will be applied to some or all model parameters.
Parameters that are to be estimated should have positive perturbations specified here.
The specification is given using the \code{\link[pomp]{rw.sd}} function, which creates a list of unevaluated expressions.
The latter are evaluated in a context where the model time variable is defined (as \code{time}).
The expression \code{ivp(s)} can be used in this context as shorthand for \preformatted{ifelse(time==time[1],s,0).}
Likewise, \code{ivp(s,lag)} is equivalent to \preformatted{ifelse(time==time[lag],s,0).}
See below for some examples.

The perturbations that are applied are normally distributed with the specified s.d.
If parameter transformations have been supplied, then the perturbations are applied on the transformed (estimation) scale.}

\item{cooling.type}{specifications for the cooling schedule,
i.e., the manner and rate with which the intensity of the parameter perturbations is reduced with successive filtering iterations.
\code{cooling.type} specifies the nature of the cooling schedule.
See below (under \dQuote{Specifying the perturbations}) for more detail.}

\item{cooling.fraction.50}{specifications for the cooling schedule,
i.e., the manner and rate with which the intensity of the parameter perturbations is reduced with successive filtering iterations.
\code{cooling.type} specifies the nature of the cooling schedule.
See below (under \dQuote{Specifying the perturbations}) for more detail.}

\item{tol}{If the resampling weight for a particle is zero due to floating-point precision issues, it is set to the value of \code{tol} since resampling has to be done.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}

\item{...}{additional arguments supply new or modify existing model characteristics or components.
See \code{\link[pomp]{pomp}} for a full list of recognized arguments.

When named arguments not recognized by \code{\link[pomp]{pomp}} are provided, these are made available to all basic components via the so-called \dfn{userdata} facility.
This allows the user to pass information to the basic components outside of the usual routes of covariates (\code{covar}) and model parameters (\code{params}).
See \link[pomp:userdata]{userdata} for information on how to use this facility.}
}
\value{
Upon successful completion, \code{iubf()} returns an object of class
\sQuote{iubfd_spatPomp}. This object contains the convergence record of the iterative algorithm with
respect to the likelihood and the parameters of the model (which can be accessed using the \code{traces}
attribute) as well as a final parameter estimate, which can be accessed using the \code{coef()}. The
algorithmic parameters used to run \code{iubf()} are also included.
}
\description{
An algorithm for estimating the parameters of a spatiotemporal partially-observed Markov process.
Running \code{iubf} causes the algorithm to perform a specified number of iterations of unadapted simulations with parameter perturbation and parameter resamplings.
At each iteration, unadapted simulations are performed on a perturbed version of the model, in which the parameters to be estimated are subjected to random perturbations at each observation.
After cycling through the data, each replicate's weight is calculated and is used to rank the bootstrap replictates. The highest ranking replicates are recycled into the next iteration.
This extra variability introduced through parameter perturbation effectively smooths the likelihood surface and combats particle depletion by introducing diversity into particle population.
As the iterations progress, the magnitude of the perturbations is diminished according to a user-specified cooling schedule.
}
\section{Methods}{

The following methods are available for such an object:
\describe{
\item{\code{\link{coef}}}{ extracts the point estimate }
}
}

\seealso{
Other particle filter methods: 
\code{\link{abfir}()},
\code{\link{abf}()},
\code{\link{bpfilter}()},
\code{\link{enkf}()},
\code{\link{girf}()},
\code{\link{ienkf}()},
\code{\link{igirf}()}

Other spatPomp parameter estimation methods: 
\code{\link{ienkf}()},
\code{\link{igirf}()}
}
\concept{particle filter methods}
\concept{spatPomp parameter estimation methods}
