aa_summariseReplicateRuns<-function(FILEPATH,SAMPLESIZES,MEASURES,RESULTFILENAME,ALTFILENAME,OUTPUTFILECOLSTART,OUTPUTFILECOLEND,AA_SIM_RESULTS,TIMEPOINTS=NULL,TIMEPOINTSCALE=NULL)
{
	if(is.null(TIMEPOINTS))
	{
		SAMPLE_SIZE_RESULTS<-NULL
		
		# Check the Measures and Parameters for Spaces - R will have replaced these with a dot
		MEASURES<-table_header_check(MEASURES)

		for(SAMPLESIZE in 1:length(SAMPLESIZES))
		{
			for(SET in 1:20)
			{
				print(paste("Processing Sample Size ",SAMPLESIZES[SAMPLESIZE]," Set ",SET,sep=""))

				SAMPLE_FILEPATH<-paste(FILEPATH,"/",SAMPLESIZES[SAMPLESIZE],"/",SET,"/",sep="")
	
				MEDIANS<-data.frame(getMediansSubset(SAMPLE_FILEPATH,SAMPLESIZES[SAMPLESIZE],MEASURES,RESULTFILENAME,
							ALTFILENAME,OUTPUTFILECOLSTART,OUTPUTFILECOLEND))

				if(nrow(MEDIANS)>0)
				{

					# NOW TO TAKE THE MEDIAN OF THE MEDIANS FOR THIS SET OF RUNS
					SET_RESULT<-cbind(array(SAMPLESIZES[SAMPLESIZE],dim=nrow(MEDIANS)),array(SET,dim=nrow(MEDIANS)),MEDIANS)
					#SET_RESULT<-cbind(SAMPLESIZES[SAMPLESIZE],SET)
					#for(MEASURE in 1:length(MEASURES))
					#{
					#	SET_RESULT<-cbind(SET_RESULT,median(MEDIANS[[MEASURES[MEASURE]]],na.rm = TRUE))
					#}

					SAMPLE_SIZE_RESULTS<-rbind(SAMPLE_SIZE_RESULTS,SET_RESULT)
				}		
			}
		}

		colnames(SAMPLE_SIZE_RESULTS)<-c("SampleSize","Set",MEASURES)

		RESULTSFILE = paste(FILEPATH,"/",AA_SIM_RESULTS,sep="")
		print(paste("Writing Median Results to CSV File: ",RESULTSFILE,sep=""))
		write.csv(SAMPLE_SIZE_RESULTS,RESULTSFILE,quote = FALSE,row.names=FALSE)
	}
	else
	{
		for(n in 1:length(TIMEPOINTS))
		{

			TIMEPOINTPROCESSING<-TIMEPOINTS[n]
			print(paste("PROCESSING TIMEPOINT: ",TIMEPOINTPROCESSING,sep=""))

			RESULTFILEFORMAT<-substr(RESULTFILENAME,(nchar(RESULTFILENAME)+1)-3,nchar(RESULTFILENAME))
			SIMRESULTFILENAME<-paste(substr(RESULTFILENAME,0,nchar(RESULTFILENAME)-4),"_",TIMEPOINTPROCESSING,".",RESULTFILEFORMAT,sep="")
		
			if(!is.null(ALTFILENAME))
			{
				ALTFILENAMEFULL<-paste(substr(ALTFILENAME,0,nchar(ALTFILENAME)-4),"_",TIMEPOINTPROCESSING,".",RESULTFILEFORMAT,sep="")
			}
			else
			{
				ALTFILENAMEFULL<-ALTFILENAME
			}

			AA_SIM_RESULTS_FORMAT<-substr(AA_SIM_RESULTS,(nchar(AA_SIM_RESULTS)+1)-3,nchar(AA_SIM_RESULTS))
			AA_SIM_RESULTS_FULL<-paste(substr(AA_SIM_RESULTS,0,nchar(AA_SIM_RESULTS)-4),"_",TIMEPOINTPROCESSING,".",AA_SIM_RESULTS_FORMAT,sep="")


			aa_summariseReplicateRuns(FILEPATH,SAMPLESIZES,MEASURES,SIMRESULTFILENAME,ALTFILENAMEFULL,OUTPUTFILECOLSTART,OUTPUTFILECOLEND,
							AA_SIM_RESULTS_FULL,TIMEPOINTS=NULL,TIMEPOINTSCALE=NULL)

		}
	}
}
