oat_plotResultDistribution <-
function(FILEPATH,PARAMETERS,PMIN,PMAX,PINC,MEASURES,MEASURE_SCALE,MEDIANSFILENAME,TIMEPOINT,TIMEPOINTSCALE)
{
	for(PARAM in 1:length(PARAMETERS))
	{
		ALLRESULTS<-NULL

		for(l in 1:length(MEASURES))
		{
			PARAMVAL<-PMIN[PARAM]
			COMBINEDRESULTS<-NULL

			while(PARAMVAL<=PMAX[PARAM])	
			{
				VALUERESULTS<-paste(FILEPATH,"/",PARAMETERS[PARAM],"/",toString(PARAMVAL),
					"/",MEDIANSFILENAME,sep="")

				if(file.exists(VALUERESULTS))
				{
					RESULTS<-read.csv(VALUERESULTS,header=TRUE)
					LABEL<-NULL
					RUNRESULTS<-NULL
	
					for(k in 1:length(RESULTS[,MEASURES[l]]))
					{
						LABEL<-rbind(LABEL,PARAMVAL[1])
					}

					RUNRESULTS<-cbind(RESULTS[,MEASURES[l]],LABEL)
	
					COMBINEDRESULTS<-rbind(COMBINEDRESULTS,RUNRESULTS)
				}
		
				PARAMVAL<-PARAMVAL+PINC[PARAM]
			}

			if(!is.null(COMBINEDRESULTS))
			{
				colnames(COMBINEDRESULTS)<-c(MEASURES[l],"Run")

				# BOXPLOT THE MEASURE
				if(is.null(TIMEPOINT))
				{
					GRAPHFILE = paste(FILEPATH,"/",PARAMETERS[PARAM],"/",PARAMETERS[PARAM],"_",
						MEASURES[l],"BP.pdf",sep="")
					GRAPHTITLE<-paste("Distribution of ",MEASURES[l], " Responses \n when altering parameter ",
						PARAMETERS[PARAM],sep="")
				}
				else
				{
					GRAPHFILE = paste(FILEPATH,"/",PARAMETERS[PARAM],"/",PARAMETERS[PARAM],"_",
						MEASURES[l],"BP_",TIMEPOINT,".pdf",sep="")
					GRAPHTITLE<-paste("Distribution of ",MEASURES[l], " Responses \n when altering parameter ",
						PARAMETERS[PARAM]," at Timepoint ",TIMEPOINT," ",TIMEPOINTSCALE,sep="")
				}
	
				pdf(GRAPHFILE)			
	
				# GENERATE YLABEL BASED ON PARAMETER MEASURE
				YLABEL<-paste("Median ",PARAMETERS[PARAM]," (",MEASURE_SCALE[PARAM],")",sep="")
				MEASURESLAB<-MEASURES[l]
			
				boxplot(COMBINEDRESULTS[,1]~COMBINEDRESULTS[,2],ylab=YLABEL,xlab="Parameter Value",main=GRAPHTITLE)
			
				dev.off()
			}
		}
	}
}

