efast_get_overall_medians <-
function(FILEPATH,NUMCURVES,PARAMETERS,NUMSAMPLES,MEASURES,MEDIANSFILENAME,CURVERESULTSFILENAME)
{
	# CURVERESULTSFILENAME IS ALLRESULTS.CSV FOR ONE TIMEPOINT
	# ALL RESULTS - WILL HOLD THE MEDIAN VALUE RESULTS FOR ALL RUNS
	# IN ORDER ON ROW - 
	for(CURVE in 1:NUMCURVES)			# CURVE
	{
		ALLRESULTS<-NULL
		for(SAMPLE in 1:NUMSAMPLES)
		{
			ALLRESULTSROW<-NULL
			for(PARAM in 1:length(PARAMETERS))
			{
				# READ IN THE MEDIANS FILE FOR THIS PARAMETER SET
				MEDIANSFILEPATH<-paste(FILEPATH,"/",CURVE,"/",PARAM,"/",SAMPLE,sep="")

				ALLMEDIANS<-read.csv(paste(MEDIANSFILEPATH,"/",MEDIANSFILENAME,sep=""),header=TRUE)

				# FOR THIS PARAMETER SET, GENERATE THE OVERALL MEDIANS FOR EACH OF MEASURE
				MEDIANSFORALLMEASURES<-NULL
				for(l in 1:length(MEASURES))
				{
					MEASUREMEDIAN <- median(ALLMEDIANS[MEASURES[l]][,1],na.rm=TRUE)
					MEDIANSFORALLMEASURES<-cbind(MEDIANSFORALLMEASURES,MEASUREMEDIAN)
				}
	
				# APPEND THESE TO THE ALL RESULTS NEW ROW
				ALLRESULTSROW<-cbind(ALLRESULTSROW,MEDIANSFORALLMEASURES)				
			}
			
			ALLRESULTS<-rbind(ALLRESULTS,ALLRESULTSROW)

		}

		# NOW WRITE THE RESULTS FOR THIS CURVE TO A FILE
		ALLRESULTSFILE = paste(FILEPATH,CURVE,"/",CURVERESULTSFILENAME,sep="")

		# GENERATE THE COLHEADERS FOR PRESENTATION SAKE
		COLHEADERS<-NULL
		for(p in 1:length(PARAMETERS))
		{
			for(m in 1:length(MEASURES))
			{
				COLHEADERS<-cbind(COLHEADERS,paste(PARAMETERS[p],"_Median",MEASURES[m],sep=""))
			}
		}

		colnames(ALLRESULTS)<-COLHEADERS
		write.csv(ALLRESULTS,ALLRESULTSFILE,quote = FALSE,row.names=FALSE)
	}
}

