% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_var.R
\name{sparse_var}
\alias{sparse_var}
\title{Calculate variance from sparse vectors}
\usage{
sparse_var(x, na_rm = FALSE)
}
\arguments{
\item{x}{A sparse numeric vector.}

\item{na_rm}{Logical, whether to remove missing values. Defaults to \code{FALSE}.}
}
\value{
single numeric value.
}
\description{
Calculate variance from sparse vectors
}
\details{
This function, as with any of the other helper functions assumes that the
input \code{x} is a sparse numeric vector. This is done for performance reasons,
and it is thus the users responsibility to perform input checking.

Much like \code{\link[=var]{var()}} it uses the denominator \code{n-1}.
}
\examples{
sparse_var(
  sparse_double(1000, 1, 1000)
)

sparse_var(
  sparse_double(1000, 1, 1000, default = 1)
)

sparse_var(
  sparse_double(c(10, 50, 11), c(1, 50, 111), 1000)
)

sparse_var(
  sparse_double(c(10, NA, 11), c(1, 50, 111), 1000)
)

sparse_var(
  sparse_double(c(10, NA, 11), c(1, 50, 111), 1000),
  na_rm = TRUE
)

}
