% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsebnUtils-options.R
\name{setGraphPackage}
\alias{getGraphPackage}
\alias{setGraphPackage}
\title{Change data structure for representing graphs internally}
\usage{
setGraphPackage(pkg, matchPlot = TRUE, coerce = FALSE)

getGraphPackage()
}
\arguments{
\item{pkg}{The desired package; default value is \code{NULL} corresponding to \link{edgeList}.}

\item{matchPlot}{Force the underlying plotting mechanism to match the selected package (see \link{setPlotPackage}).}

\item{coerce}{If \code{TRUE}, then all of the fitted objects in the global environment will be coerced to be compatible with the selected package. This will overwrite your existing data.}
}
\description{
Changes the output of the main algorithms to be compatible with other packages in the R ecosystem.
}
\details{
\code{sparsebn} is compatible with four different data structures for representing graphs:
\link{edgeList} (default), \link[graph]{graphNEL-class} (from the \code{graph} package),
\link[igraph]{igraph} (from the \link[igraph]{igraph} package), and \link[network]{network} (from
\link[network]{network-package}). \link{edgeList} is provided by default in \code{sparsebn}, however,
the other three options require that extra packages are installed.
}
\section{Functions}{
\itemize{
\item \code{getGraphPackage}: Returns the current choice of graph package ( \code{NULL} corresponds to no selection)
}}
\seealso{
\code{\link{setPlotPackage}}, \code{\link{getPlotPackage}}
}

