% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutation.R
\name{sdf_bind}
\alias{sdf_bind}
\alias{sdf_bind_rows}
\alias{sdf_bind_cols}
\title{Bind multiple Spark DataFrames by row and column}
\usage{
sdf_bind_rows(..., id = NULL)

sdf_bind_cols(...)
}
\arguments{
\item{...}{Spark tbls to combine.

  Each argument can either be a Spark DataFrame or a list of
  Spark DataFrames

  When row-binding, columns are matched by name, and any missing
  columns with be filled with NA.

  When column-binding, rows are matched by position, so all data
  frames must have the same number of rows.}

\item{id}{Data frame identifier.

  When \code{id} is supplied, a new column of identifiers is
  created to link each row to its original Spark DataFrame. The labels
  are taken from the named arguments to \code{sdf_bind_rows()}. When a
  list of Spark DataFrames is supplied, the labels are taken from the
  names of the list. If no names are found a numeric sequence is
  used instead.}
}
\value{
\code{sdf_bind_rows()} and \code{sdf_bind_cols()} return \code{tbl_spark}
}
\description{
\code{sdf_bind_rows()} and \code{sdf_bind_cols()} are implementation of the common pattern of
\code{do.call(rbind, sdfs)} or \code{do.call(cbind, sdfs)} for binding many
Spark DataFrames into one.
}
\details{
The output of \code{sdf_bind_rows()} will contain a column if that column
appears in any of the inputs.
}
