% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_view.R
\name{stream_render}
\alias{stream_render}
\title{Render Stream}
\usage{
stream_render(stream = NULL, collect = 10, stats = NULL, ...)
}
\arguments{
\item{stream}{The stream to render}

\item{collect}{The interval in seconds to collect data before rendering the
'htmlwidget'.}

\item{stats}{Optional stream statistics collected using \code{stream_stats()},
when specified, \code{stream} should be omitted.}

\item{...}{Additional optional arguments.}
}
\description{
Collects streaming statistics to render the stream as an 'htmlwidget'.
}
\examples{
\dontrun{
library(sparklyr)
sc <- spark_connect(master = "local")

dir.create("iris-in")
write.csv(iris, "iris-in/iris.csv", row.names = FALSE)

stream <- stream_read_csv(sc, "iris-in/") \%>\%
  stream_write_csv("iris-out/")

stream_render(stream)
stream_stop(stream)
}
}
