% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_data.R
\name{stream_read_json}
\alias{stream_read_json}
\title{Read JSON Stream}
\usage{
stream_read_json(sc, path, name = NULL, columns = NULL, options = list(), ...)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3a://"} and \samp{"file://"} protocols.}

\item{name}{The name to assign to the newly generated stream.}

\item{columns}{A vector of column names or a named vector of column types.
If specified, the elements can be \code{"binary"} for \code{BinaryType},
\code{"boolean"} for \code{BooleanType}, \code{"byte"} for \code{ByteType},
\code{"integer"} for \code{IntegerType}, \code{"integer64"} for \code{LongType},
\code{"double"} for \code{DoubleType}, \code{"character"} for \code{StringType},
\code{"timestamp"} for \code{TimestampType} and \code{"date"} for \code{DateType}.}

\item{options}{A list of strings with additional options.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Reads a JSON stream as a Spark dataframe stream.
}
\examples{
\dontrun{

sc <- spark_connect(master = "local")

dir.create("json-in")
jsonlite::write_json(list(a = c(1,2), b = c(10,20)), "json-in/data.json")

json_path <- file.path("file://", getwd(), "json-in")

stream <- stream_read_json(sc, json_path) \%>\% stream_write_json("json-out")

stream_stop(stream)

}

}
\seealso{
Other Spark stream serialization: 
\code{\link{stream_read_csv}()},
\code{\link{stream_read_delta}()},
\code{\link{stream_read_kafka}()},
\code{\link{stream_read_orc}()},
\code{\link{stream_read_parquet}()},
\code{\link{stream_read_socket}()},
\code{\link{stream_read_text}()},
\code{\link{stream_write_console}()},
\code{\link{stream_write_csv}()},
\code{\link{stream_write_delta}()},
\code{\link{stream_write_json}()},
\code{\link{stream_write_kafka}()},
\code{\link{stream_write_memory}()},
\code{\link{stream_write_orc}()},
\code{\link{stream_write_parquet}()},
\code{\link{stream_write_text}()}
}
\concept{Spark stream serialization}
