% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection_spark.R
\name{spark_connect}
\alias{spark_connect}
\title{Connect to Spark}
\usage{
spark_connect(master, spark_home = Sys.getenv("SPARK_HOME"),
  method = c("shell"), app_name = "sparklyr", version = NULL,
  hadoop_version = NULL, config = spark_config(),
  extensions = sparklyr::registered_extensions())
}
\arguments{
\item{master}{Spark cluster url to connect to. Use \code{"local"} to connect to a local
instance of Spark installed via \code{\link{spark_install}}.}

\item{spark_home}{Spark home directory (defaults to SPARK_HOME environment variable).
If \code{SPARK_HOME} is defined it will be always be used unless the \code{version}
paramater is specified to force the use of a locally installed version.}

\item{method}{of connecting to spark (currently only "shell" is supported, additional
methods may come later)}

\item{app_name}{Application name to be used while running in the Spark cluster}

\item{version}{Version of Spark (only applicable for local master)}

\item{hadoop_version}{Version of Hadoop (only applicable for local master)}

\item{config}{Configuration for connection (see \code{\link{spark_config} for details}).}

\item{extensions}{Extension packages to enable for this connection. By default will
enable all packages that previously called \code{sparklyr::register_extension}.}
}
\value{
Connection to Spark local instance or remote cluster
}
\description{
Connect to Spark
}
\seealso{
Other Spark connections: \code{\link{spark_disconnect}}
}

