% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacy_initialize.R
\name{spacy_initialize}
\alias{spacy_initialize}
\title{Initialize spaCy}
\usage{
spacy_initialize(model = "en", python_executable = NULL,
  virtualenv = NULL, condaenv = NULL, ask = FALSE,
  refresh_settings = FALSE, save_profile = FALSE, check_env = TRUE,
  entity = TRUE)
}
\arguments{
\item{model}{Language package for loading spaCy. Example: \code{en} (English) and
\code{de} (German). Default is \code{en}.}

\item{python_executable}{the full path to the Python executable, for which
spaCy is installed}

\item{virtualenv}{set a path to the Python virtual environment with spaCy
installed Example: \code{virtualenv = "~/myenv"}}

\item{condaenv}{set a path to the anaconda virtual environment with spaCy
installed Example: \code{condalenv = "myenv"}}

\item{ask}{logical; if \code{FALSE}, use the first spaCy installation found;
if \code{TRUE}, list available spaCy installations and prompt the user for
which to use. If another (e.g. \code{python_executable}) is set, then this
value will always be treated as \code{FALSE}.}

\item{refresh_settings}{logical; if \code{TRUE}, spacyr will ignore the saved
settings in the profile and initiate a search of new settings.}

\item{save_profile}{logical; if \code{TRUE}, the current spaCy setting will
be saved for the future use.}

\item{check_env}{logical; check whether conda/virtual environment generated
by \code{spacyr_istall()} exists}

\item{entity}{logical; if \code{FALSE} is selected, named entity recognition
is turned off in spaCy. This will speed up the parsing as it will exclude
\code{ner} from the pipeline. For details of spaCy pipeline, see
\url{https://spacy.io/usage/processing-pipelines}. The option \code{FALSE}
is available only for spaCy version 2.0.0 or higher.}
}
\description{
Initialize spaCy to call from R.
}
\author{
Akitaka Matsuo
}
