% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_centroid.R
\name{get_centroid}
\alias{get_centroid}
\title{Find central point for list of lat/long coordinates}
\usage{
get_centroid(lat, lng, coord.unit = c("degrees", "radians"))
}
\arguments{
\item{lat}{A quoted string indicating what named value in the bounding box
represents latitude. If NULL, will be inferred from bounding box names.}

\item{lng}{A quoted string indicating what named value in the bounding box
represents longitude. If NULL, will be inferred from bounding box names.}

\item{coord.unit}{The unit latitude and longitude are stored in.}
}
\description{
Find central point for list of lat/long coordinates
}
\examples{
df <- data.frame(
  lat = c(44.05771, 44.18475),
  lng = c(-73.99212, -73.81515)
)
get_centroid(df$lat, df$lng)
}
