% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_functions_sf.R
\name{simplify_network}
\alias{simplify_network}
\title{Simplify a network}
\usage{
simplify_network(
  lines,
  digits = 3,
  heal = TRUE,
  mirror = TRUE,
  keep_shortest = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{lines}{A feature collection of linestrings}

\item{digits}{An integer indicating the number of digits to keep in coordinates}

\item{heal}{A boolean indicating if the healing operation must be performed}

\item{mirror}{A boolean indicating if the mirror edges must be removed}

\item{keep_shortest}{A boolean, if TRUE, then the shortest line is kept from
mirror edges. if FALSE, then the longest line is kept.}

\item{verbose}{A boolean indicating if messages and a progress bar should be displayed}
}
\value{
A feature collection of linestrings
}
\description{
Simplify a network by applying two corrections: Healing edges and
Removing mirror edges (experimental).
}
\details{
Healing is the operation to merge two connected linestring if the are
intersecting at one extremity and do not intersect any other linestring. It helps
to reduce the complexity of the network and thus can reduce calculation time.
Removing mirror edges is the operation to remove edges that have the same
extremities. If two edges start at the same point and end at the same point,
they do not add information in the network and one can be removed to simplify
the network. One can decide to keep the longest of the two edges or the shortest.
NOTE: the edge healing does not consider lines directions currently!
}
\examples{
\donttest{
library(spNetwork)
networkgpkg <- system.file("extdata", "networks.gpkg",package = "spNetwork", mustWork = TRUE)
lines <- sf::st_read(networkgpkg,layer="mtl_network")
edited_lines <- simplify_network(lines, digits = 3, verbose = FALSE)
}
}
