% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sctest.R
\name{sc.test}
\alias{sc.test}
\alias{sc.test,sf-method}
\alias{sc.test,SpatRaster-method}
\title{spatial causality test}
\usage{
\S4method{sc.test}{sf}(
  data,
  cause,
  effect,
  k,
  block = 3,
  boot = 399,
  seed = 42,
  base = 2,
  lib = NULL,
  pred = NULL,
  threads = detectThreads(),
  detrend = TRUE,
  normalize = FALSE,
  progressbar = FALSE,
  nb = NULL
)

\S4method{sc.test}{SpatRaster}(
  data,
  cause,
  effect,
  k,
  block = 3,
  boot = 399,
  seed = 42,
  base = 2,
  lib = NULL,
  pred = NULL,
  threads = detectThreads(),
  detrend = TRUE,
  normalize = FALSE,
  progressbar = FALSE,
  grid.coord = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{cause}{name of causal variable.}

\item{effect}{name of effect variable.}

\item{k}{(optional) number of nearest neighbors used in symbolization.}

\item{block}{(optional) number of blocks used in spatial block bootstrap.}

\item{boot}{(optional) number of bootstraps to perform.}

\item{seed}{(optional) random seed.}

\item{base}{(optional) logarithm base.}

\item{lib}{(optional) libraries indices (input needed: \code{vector} - spatial vector, \code{matrix} - spatial raster).}

\item{pred}{(optional) predictions indices (input requirement same as \code{lib}).}

\item{threads}{(optional) number of threads to use.}

\item{detrend}{(optional) whether to remove the linear trend.}

\item{normalize}{(optional) whether to normalize the result.}

\item{progressbar}{(optional) whether to show the progress bar.}

\item{nb}{(optional) neighbours list.}

\item{grid.coord}{(optional) whether to detrend using cell center coordinates (\code{TRUE}) or row/column numbers (\code{FALSE}).}
}
\value{
A list
\describe{
\item{\code{sc}}{statistic for spatial causality}
\item{\code{varname}}{names of causal and effect variables}
}
}
\description{
spatial causality test
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg",package="spEDM"))
\donttest{
sc.test(columbus,"hoval","crime",k = 15)
}
}
\references{
Herrera, M., Mur, J., & Ruiz, M. (2016). Detecting causal relationships between spatial processes. Papers in Regional Science, 95(3), 577–595.
}
