% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplex.R
\name{simplex}
\alias{simplex}
\alias{simplex,sf-method}
\alias{simplex,SpatRaster-method}
\title{simplex forecast}
\usage{
\S4method{simplex}{sf}(
  data,
  column,
  target,
  lib = NULL,
  pred = NULL,
  E = 1:10,
  tau = 1,
  k = E + 2,
  nb = NULL,
  threads = detectThreads(),
  detrend = TRUE
)

\S4method{simplex}{SpatRaster}(
  data,
  column,
  target,
  lib = NULL,
  pred = NULL,
  E = 1:10,
  tau = 1,
  k = E + 2,
  threads = detectThreads(),
  detrend = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{column}{name of library variable.}

\item{target}{name of target variable.}

\item{lib}{(optional) libraries indices.}

\item{pred}{(optional) predictions indices.}

\item{E}{(optional) embedding dimensions.}

\item{tau}{(optional) step of spatial lags.}

\item{k}{(optional) number of nearest neighbors used.}

\item{nb}{(optional) neighbours list.}

\item{threads}{(optional) number of threads to use.}

\item{detrend}{(optional) whether to remove the linear trend.}
}
\value{
A list
\describe{
\item{\code{xmap}}{forecast performance}
\item{\code{varname}}{name of target variable}
\item{\code{method}}{method of cross mapping}
\item{\code{tau}}{step of time lag}
}
}
\description{
simplex forecast
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
\donttest{
simplex(columbus,"inc","crime")
}
}
\references{
Sugihara G. and May R. 1990. Nonlinear forecasting as a way of distinguishing chaos from measurement error in time series. Nature, 344:734-741.
}
