% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{analyzeFolder}
\alias{analyzeFolder}
\title{Analyze folder}
\usage{
analyzeFolder(
  myfolder,
  htmlPlots = TRUE,
  verbose = TRUE,
  samplingRate = NULL,
  dynamicRange = 80,
  silence = 0.04,
  SPL_measured = 70,
  Pref = 2e-05,
  windowLength = 50,
  step = NULL,
  overlap = 50,
  wn = "gaussian",
  zp = 0,
  cutFreq = NULL,
  voicedSeparate = TRUE,
  formants = list(verify = FALSE),
  nFormants = 3,
  pitchMethods = c("dom", "autocor"),
  pitchManual = NULL,
  entropyThres = 0.6,
  pitchFloor = 75,
  pitchCeiling = 3500,
  priorMean = 300,
  priorSD = 6,
  nCands = 1,
  minVoicedCands = NULL,
  pitchDom = list(),
  pitchAutocor = list(),
  pitchCep = list(),
  pitchSpec = list(),
  pitchHps = list(),
  harmHeight = list(type = "n"),
  shortestSyl = 20,
  shortestPause = 60,
  interpolWin = 75,
  interpolTol = 0.3,
  interpolCert = 0.3,
  pathfinding = c("none", "fast", "slow")[2],
  annealPars = list(maxit = 5000, temp = 1000),
  certWeight = 0.5,
  snakeStep = 0.05,
  snakePlot = FALSE,
  smooth = 1,
  smoothVars = c("pitch", "dom"),
  summary = NULL,
  summaryFun = c("mean", "median", "sd"),
  plot = FALSE,
  osc = "linear",
  showLegend = TRUE,
  savePlots = FALSE,
  pitchPlot = list(col = rgb(0, 0, 1, 0.75), lwd = 3, showPrior = TRUE),
  ylim = NULL,
  xlab = "Time, ms",
  ylab = "kHz",
  main = NULL,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{myfolder}{full path to target folder}

\item{htmlPlots}{if TRUE, saves an html file with clickable plots}

\item{verbose}{if TRUE, reports progress and estimated time left}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector, rather than an audio file)}

\item{dynamicRange}{dynamic range, dB. All values more than one dynamicRange
under maximum are treated as zero}

\item{silence}{(0 to 1) frames with RMS amplitude below silence threshold are
not analyzed at all. NB: this number is dynamically updated: the actual
silence threshold may be higher depending on the quietest frame, but it
will never be lower than this specified number.}

\item{SPL_measured}{sound pressure level at which the sound is presented, dB
(set to 0 to skip analyzing subjective loudness)}

\item{Pref}{reference pressure, Pa}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{overlap}{overlap between successive FFT frames, \%}

\item{wn}{window type: gaussian, hanning, hamming, bartlett, rectangular,
blackman, flattop}

\item{zp}{window length after zero padding, points}

\item{cutFreq}{if specified, spectral descriptives (peakFreq, specCentroid,
specSlope, and quartiles) are calculated only between \code{cutFreq[1]} and
\code{cutFreq[2]}. If a single number is given, analyzes frequencies from 0
to \code{cutFreq}. For ex., when analyzing recordings with varying sampling
rates, set to half the lowest sampling rate to make the spectra more
comparable. Note that "entropyThres" applies only to this frequency range,
which also affects which frames will not be analyzed with pitchAutocor.}

\item{voicedSeparate}{if TRUE, descriptives are calculated separately for the
entire sound and for the voiced frames, creating extra variables in the
output}

\item{formants}{a list of arguments passed to
\code{\link[phonTools]{findformants}} - an external function called to
perform LPC analysis}

\item{nFormants}{the number of formants to extract per STFT frame (0 = no
formant analysis, NULL = as many as possible)}

\item{pitchMethods}{methods of pitch estimation to consider for determining
pitch contour: 'autocor' = autocorrelation (~PRAAT), 'cep' = cepstral,
'spec' = spectral (~BaNa), 'dom' = lowest dominant frequency band ('' or
NULL = no pitch analysis)}

\item{pitchManual}{normally the output of \code{\link{pitch_app}} containing
a manually corrected pitch contour, ideally with the same windowLength and
step as current call to analyzeFolder; a dataframe with at least two
columns: "file" (w/o path) and "pitch" (character like "NA, 150, 175, NA")}

\item{entropyThres}{pitch tracking is only performed for frames with Weiner
entropy below \code{entropyThres}, but other spectral descriptives are
still calculated (NULL = analyze everything)}

\item{pitchFloor}{absolute bounds for pitch candidates (Hz)}

\item{pitchCeiling}{absolute bounds for pitch candidates (Hz)}

\item{priorMean}{specifies the mean (Hz) and standard deviation
(semitones) of gamma distribution describing our prior knowledge about the
most likely pitch values for this file. For ex., \code{priorMean = 300,
priorSD = 6} gives a prior with mean = 300 Hz and SD = 6 semitones (half
an octave)}

\item{priorSD}{specifies the mean (Hz) and standard deviation
(semitones) of gamma distribution describing our prior knowledge about the
most likely pitch values for this file. For ex., \code{priorMean = 300,
priorSD = 6} gives a prior with mean = 300 Hz and SD = 6 semitones (half
an octave)}

\item{nCands}{maximum number of pitch candidates per method (except for
\code{dom}, which returns at most one candidate per frame), normally 1...4}

\item{minVoicedCands}{minimum number of pitch candidates that have to be
defined to consider a frame voiced (if NULL, defaults to 2 if \code{dom} is
among other candidates and 1 otherwise)}

\item{pitchDom}{a list of control parameters for pitch tracking using the
lowest dominant frequency band or "dom" method; see details and
\code{?soundgen:::getDom}}

\item{pitchAutocor}{a list of control parameters for pitch tracking using the
autocorrelation or "autocor" method; see details and
\code{?soundgen:::getPitchAutocor}}

\item{pitchCep}{a list of control parameters for pitch tracking using the
cepstrum or "cep" method; see details and \code{?soundgen:::getPitchCep}}

\item{pitchSpec}{a list of control parameters for pitch tracking using the
BaNa or "spec" method; see details and \code{?soundgen:::getPitchSpec}}

\item{pitchHps}{a list of control parameters for pitch tracking using the
harmonic product spectrum ("hps") method; see details and
\code{?soundgen:::getPitchHps}}

\item{harmHeight}{a list of control parameters for estimating how high
harmonics reach in the spectrum; see details and \code{?soundgen:::harmHeight}}

\item{shortestSyl}{the smallest length of a voiced segment (ms) that
constitutes a voiced syllable (shorter segments will be replaced by NA, as
if unvoiced)}

\item{shortestPause}{the smallest gap between voiced syllables (ms): large
value = interpolate and merge, small value = treat as separate syllables
separated by an unvoiced gap
means they shouldn't be merged into one voiced syllable}

\item{interpolWin}{control the behavior of
interpolation algorithm when postprocessing pitch candidates. To turn off
interpolation, set \code{interpolWin = 0}. See \code{soundgen:::pathfinder}
for details.}

\item{interpolTol}{control the behavior of
interpolation algorithm when postprocessing pitch candidates. To turn off
interpolation, set \code{interpolWin = 0}. See \code{soundgen:::pathfinder}
for details.}

\item{interpolCert}{control the behavior of
interpolation algorithm when postprocessing pitch candidates. To turn off
interpolation, set \code{interpolWin = 0}. See \code{soundgen:::pathfinder}
for details.}

\item{pathfinding}{method of finding the optimal path through pitch
candidates: 'none' = best candidate per frame, 'fast' = simple heuristic,
'slow' = annealing. See \code{soundgen:::pathfinder}}

\item{annealPars}{a list of control parameters for postprocessing of
pitch contour with SANN algorithm of \code{\link[stats]{optim}}. This is
only relevant if \code{pathfinding = 'slow'}}

\item{certWeight}{(0 to 1) in pitch postprocessing, specifies how much we
prioritize the certainty of pitch candidates vs. pitch jumps / the internal
tension of the resulting pitch curve}

\item{snakeStep}{optimized path through pitch candidates is further
processed to minimize the elastic force acting on pitch contour. To
disable, set \code{snakeStep = 0}}

\item{snakePlot}{if TRUE, plots the snake}

\item{smooth}{if \code{smooth} is a positive number, outliers of
the variables in \code{smoothVars} are adjusted with median smoothing.
\code{smooth} of 1 corresponds to a window of ~100 ms and tolerated
deviation of ~4 semitones. To disable, set \code{smooth = 0}}

\item{smoothVars}{if \code{smooth} is a positive number, outliers of
the variables in \code{smoothVars} are adjusted with median smoothing.
\code{smooth} of 1 corresponds to a window of ~100 ms and tolerated
deviation of ~4 semitones. To disable, set \code{smooth = 0}}

\item{summary}{deprecated}

\item{summaryFun}{functions used to summarize each acoustic characteristic,
eg "c('mean', 'sd')"; user-defined functions are fine (see examples); NAs
are omitted automatically for mean/median/sd/min/max/range/sum, otherwise
take care of NAs yourself; if \code{summaryFun = NULL}, analyze() returns a
list containing frame-by-frame values}

\item{plot}{if TRUE, produces a spectrogram with pitch contour overlaid}

\item{osc}{should an oscillogram be shown under the spectrogram? none = no
osc; linear = on the original scale; dB = in decibels}

\item{showLegend}{if TRUE, adds a legend with pitch tracking methods}

\item{savePlots}{if TRUE, saves plots as .png files}

\item{pitchPlot}{a list of graphical parameters for displaying the final
pitch contour. Set to \code{list(type = 'n')} to suppress}

\item{ylim}{frequency range to plot, kHz (defaults to 0 to Nyquist frequency)}

\item{xlab}{plotting parameters}

\item{ylab}{plotting parameters}

\item{main}{plotting parameters}

\item{width}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{height}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{units}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{res}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{...}{other graphical parameters passed to \code{\link{spectrogram}}}
}
\value{
If \code{summary} is TRUE, returns a dataframe with one row per audio
  file. If \code{summary} is FALSE, returns a list of detailed descriptives.
}
\description{
Acoustic analysis of all wav/mp3 files in a folder. See \code{\link{analyze}}
and vignette('acoustic_analysis', package = 'soundgen') for further details.
See \code{\link{pitch_app}} for a more realistic workflow: extract manually
corrected pitch contours with pitch_app(), then run analyzeFolder() with
these manual contours
}
\examples{
\dontrun{
# download 260 sounds from Anikin & Persson (2017)
# http://cogsci.se/publications/anikin-persson_2017_nonlinguistic-vocs/260sounds_wav.zip
# unzip them into a folder, say '~/Downloads/temp'
myfolder = '~/Downloads/temp'  # 260 .wav files live here
s = analyzeFolder(myfolder, verbose = TRUE)  # ~ 10-20 minutes!
# s = write.csv(s, paste0(myfolder, '/temp.csv'))  # save a backup

# Check accuracy: import manually verified pitch values (our "key")
# pitchManual   # "ground truth" of mean pitch per sound
# pitchContour  # "ground truth" of complete pitch contours per sound
files_manual = paste0(names(pitchManual), '.wav')
idx = match(s$file, files_manual)  # in case the order is wrong
s$key = pitchManual[idx]

# Compare manually verified mean pitch with the output of analyzeFolder:
cor(s$key, s$pitch_median, use = 'pairwise.complete.obs')
plot(s$key, s$pitch_median, log = 'xy')
abline(a=0, b=1, col='red')

# Re-running analyzeFolder with manually corrected contours gives correct
pitch-related descriptives like amplVoiced and harmonics (NB: you get it "for
free" when running pitch_app)
s1 = analyzeFolder(myfolder, verbose = TRUE, pitchManual = pitchContour)
plot(s$harmonics_median, s1$harmonics_median)
abline(a=0, b=1, col='red')

# Save spectrograms with pitch contours plus an html file for easy access
s2 = analyzeFolder('~/Downloads/temp', savePlots = TRUE,
  showLegend = TRUE, pitchManual = pitchContour,
  width = 20, height = 12,
  units = 'cm', res = 300, ylim = c(0, 5))
}
}
\seealso{
\code{\link{analyze}} \code{\link{pitch_app}}
  \code{\link{getLoudness}} \code{\link{segment}} \code{\link{getRMS}}
}
