% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrogram.R
\name{spectrogramFolder}
\alias{spectrogramFolder}
\title{Save spectrograms per folder}
\usage{
spectrogramFolder(myfolder, htmlPlots = TRUE, verbose = TRUE,
  windowLength = 50, step = NULL, overlap = 50, wn = "gaussian",
  zp = 0, ylim = NULL, osc = TRUE, xlab = "Time, ms", ylab = "kHz",
  width = 900, height = 500, units = "px", res = NA, ...)
}
\arguments{
\item{myfolder}{full path to the folder containing .wav files}

\item{htmlPlots}{if TRUE, saves an html file with clickable plots}

\item{verbose}{if TRUE, reports progress and estimated time left}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{overlap}{overlap between successive FFT frames, \%}

\item{wn}{window type: gaussian, hanning, hamming, bartlett, rectangular,
blackman, flattop}

\item{zp}{window length after zero padding, points}

\item{ylim}{frequency range to plot, kHz (defaults to 0 to Nyquist frequency)}

\item{osc}{should an oscillogram be shown under the spectrogram? TRUE / FALSE}

\item{xlab}{graphical parameters}

\item{ylab}{graphical parameters}

\item{width}{parameters passed to
\code{\link[grDevices]{jpeg}} if the plot is saved}

\item{height}{parameters passed to
\code{\link[grDevices]{jpeg}} if the plot is saved}

\item{units}{parameters passed to
\code{\link[grDevices]{jpeg}} if the plot is saved}

\item{res}{parameters passed to
\code{\link[grDevices]{jpeg}} if the plot is saved}

\item{...}{other parameters passed to \code{\link{spectrogram}}}
}
\description{
Creates spectrograms of all .wav files in a folder and save them as .jpeg
files in the same folder. This is a lot faster than running
\code{\link{analyzeFolder}} if you don't need pitch tracking. By default it
also creates an html file with a list of audio files and their spectrograms
in the same folder. If you open it in a browser that supports playing .wav
files (e.g. Firefox or Chrome), you can view the spetrograms and click on
them to play each sound. Unlike \code{\link{analyzeFolder}},
spectrogramFolder supports plotting both a spectrogram and an oscillogram if
\code{osc = TRUE}.
}
\examples{
\dontrun{
spectrogramFolder('~/Downloads/temp',
                  windowLength = 40, overlap = 75,  # spectrogram pars
                  width = 1500, height = 900        # passed to jpeg()
                  )
# note that the folder now also contains an html file with clickable plots
}
}
