% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_soundgen.R
\name{getEnv}
\alias{getEnv}
\title{Get amplitude envelope}
\usage{
getEnv(sound, windowLength_points, method = c("rms", "peak", "mean")[1])
}
\arguments{
\item{sound}{input vector oscillating about zero}

\item{windowLength_points}{the length of smoothing window, points. If
specified, overrides both \code{windowLength} and \code{samplingRate}}

\item{method}{'peak' for peak amplitude per window, 'rms' for root mean
square amplitude, 'mean' for mean (for DC offset removal)}
}
\description{
Internal soundgen function
}
\details{
Returns the smoothed amplitude envelope of a waveform on the original scale.
}
\examples{
a = rnorm(500) * seq(1, 0, length.out = 500)
plot(soundgen:::getEnv(a, 20))
}
\keyword{internal}
