% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_weierstrass.R
\name{generate_weierstrass_function}
\alias{generate_weierstrass_function}
\title{Generator for the Weierstrass function.}
\usage{
generate_weierstrass_function(dimensions)
}
\arguments{
\item{dimensions}{[\code{integer(1)}] Size of parameter space.}
}
\value{
A \code{soo_function}.
}
\description{
The definition used is
}
\details{
\deqn{f(x) = \displaystyle \sum_{i=1}^n \left( \sum_{k=0}^{20} \left(0.5^k \cos \left(2 \pi 3^k \left(x_i + 0.5 \right)\right)\right]\right) - n \sum_{k=0}^{20} \left[a^k \cos \left( \pi b^k \right)\right)}
}
\examples{
f <- generate_weierstrass_function(2)
plot(f, rank=TRUE)

}
