% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweptsine.R
\name{sweptsine}
\alias{sweptsine}
\title{Generate a frequency-swept sine wave}
\usage{
sweptsine(
  f0 = 100,
  f1 = 2500,
  sweep.time = 1,
  time.unit = "seconds",
  A = 1,
  samp.rate = 44100,
  output = "wave",
  ...
)
}
\arguments{
\item{f0}{Start frequency}

\item{f1}{End frequency}

\item{sweep.time}{Duration of swept wave}

\item{time.unit}{One of "seconds", "samples"}

\item{A}{Amplitude of wave}

\item{samp.rate}{Sample rate of swept wave}

\item{output}{"wave" for a Wave object, or "vector"}

\item{...}{Additional arguments to pass to data2Wave}
}
\value{
A swept wave object of the type specified in output.
}
\description{
Generates a frequency swept sine wave and returns it as a Wave object or vector.
}
\examples{
sweptsine()

}
