% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaveFilter.R
\name{bandpass}
\alias{bandpass}
\title{Simple bandpass filter}
\usage{
bandpass(from, to, ...)
}
\arguments{
\item{from}{Bottom of bandpass frequency (Hz).}

\item{to}{Top of bandpass frequency (Hz).}

\item{...}{Further arguments to pass to ffilter.}
}
\value{
A WaveFilter object.
}
\description{
Creates a band pass WaveFilter between values specified to a Wave object.
}
\details{
This is a simple wrapper function to the seewave ffilter function allowing its
use with filterw and pipes.
}
\examples{
\dontrun{
nwave <- noise("white", duration=44100, samp.rate=44100)

fwave <- filterWave(nwave, bandpass(from=1000, to=2000))
nwave |> filterWave(bandpass(from=1000, to=2000)) -> fwave
}
}
